/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli.csv;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.CharsetDecoder;
import java.nio.file.Path;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.text.TextInputSupport;
import nbbrd.picocsv.Csv;

public class PicocsvInputSupport
extends TextInputSupport {
    @NonNull
    private Csv.Format format = Csv.Format.DEFAULT;
    @NonNull
    private Csv.ReaderOptions options = Csv.ReaderOptions.DEFAULT;

    @SafeVarargs
    @NonNull
    public static PicocsvInputSupport newPicocsvInputSupport(CommandSupporter<? super PicocsvInputSupport> ... supporters) {
        if (supporters == null) {
            throw new NullPointerException("supporters is marked non-null but is null");
        }
        return CommandSupporter.create(PicocsvInputSupport::new, supporters);
    }

    @NonNull
    public Csv.Reader newCsvReader(@NonNull Path file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        CharsetDecoder decoder = this.newDecoder(file);
        return Csv.Reader.of((Csv.Format)this.getFormat(), (Csv.ReaderOptions)this.getOptions(), (Reader)this.newInputStreamReader(file, decoder), (int)this.getCharBufferSize(file, decoder));
    }

    @NonNull
    @Generated
    public Csv.Format getFormat() {
        return this.format;
    }

    @NonNull
    @Generated
    public Csv.ReaderOptions getOptions() {
        return this.options;
    }

    @Generated
    public void setFormat(@NonNull Csv.Format format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.format = format;
    }

    @Generated
    public void setOptions(@NonNull Csv.ReaderOptions options) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.options = options;
    }

    @Generated
    protected PicocsvInputSupport() {
    }
}

