/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli.csv;

import java.io.IOException;
import java.io.Reader;
import nbbrd.console.picocli.csv.CsvNewLine;
import nbbrd.console.picocli.text.TextInput;
import nbbrd.picocsv.Csv;

public interface CsvInput
extends TextInput {
    public char getDelimiter();

    public CsvNewLine getSeparator();

    public boolean isLenientSeparator();

    public char getQuote();

    public char getComment();

    default public Csv.Format toFormat() {
        return Csv.Format.RFC4180.toBuilder().delimiter(this.getDelimiter()).quote(this.getQuote()).separator(this.getSeparator().getSeparator()).comment(this.getComment()).build();
    }

    default public Csv.ReaderOptions toParsing() {
        return Csv.ReaderOptions.builder().lenientSeparator(this.isLenientSeparator()).build();
    }

    default public Csv.Reader newCsvReader(Reader charReader) throws IOException {
        return Csv.Reader.of((Csv.Format)this.toFormat(), (Csv.ReaderOptions)this.toParsing(), (Reader)charReader, (int)8192);
    }

    default public Csv.Reader newCsvReader() throws IOException {
        return this.newCsvReader(this.newCharReader());
    }
}

