/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import lombok.Generated;

public final class ManifestHelper {
    public static final String IMPL_TITLE_HEADER = "Implementation-Title";
    public static final String IMPL_VERSION_HEADER = "Implementation-Version";

    public static Optional<Manifest> getByTitle(String title) throws IOException {
        return ManifestHelper.get(manifest -> title.equals(manifest.getMainAttributes().getValue(IMPL_TITLE_HEADER)));
    }

    public static Optional<Manifest> get(Predicate<? super Manifest> filter) throws IOException {
        Enumeration<URL> resources = ManifestHelper.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            InputStream stream = url.openStream();
            try {
                Manifest manifest = new Manifest(stream);
                if (!filter.test(manifest)) continue;
                Optional<Manifest> optional = Optional.of(manifest);
                return optional;
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return Optional.empty();
    }

    public static String[] getVersion(Manifest manifest) {
        Attributes attr = manifest.getMainAttributes();
        return new String[]{attr.getValue(IMPL_TITLE_HEADER) + " version \"" + attr.getValue(IMPL_VERSION_HEADER) + "\""};
    }

    @Generated
    private ManifestHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

