/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli;

import internal.console.picocli.GzipFiles;
import java.nio.file.Files;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import nbbrd.console.picocli.ByteOutputSupport;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.FileSink;
import picocli.CommandLine;

public class GzipOutputOptions
implements CommandSupporter<ByteOutputSupport> {
    @CommandLine.Option(names={"-Z"}, description={"Compress the output file with gzip."}, defaultValue="false")
    private boolean gzipped = false;

    public FileSink asFileSink() {
        return (file, options) -> this.isGzipped() || GzipFiles.isGzippedFileName(file) ? new GZIPOutputStream(Files.newOutputStream(file, options)) : Files.newOutputStream(file, options);
    }

    @Override
    public void applyTo(ByteOutputSupport support) {
        support.setFileSink(this.asFileSink());
    }

    @Generated
    public boolean isGzipped() {
        return this.gzipped;
    }

    @Generated
    public void setGzipped(boolean gzipped) {
        this.gzipped = gzipped;
    }
}

