/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli;

import internal.console.picocli.GzipFiles;
import java.nio.file.Files;
import java.util.zip.GZIPInputStream;
import lombok.Generated;
import nbbrd.console.picocli.ByteInputSupport;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.FileSource;
import picocli.CommandLine;

public class GzipInputOptions
implements CommandSupporter<ByteInputSupport> {
    @CommandLine.Option(names={"-z"}, description={"Uncompress the input file with gzip."}, defaultValue="false")
    private boolean gzipped = false;

    public FileSource asFileSource() {
        return (file, options) -> this.isGzipped() || GzipFiles.isGzippedFileName(file) ? new GZIPInputStream(Files.newInputStream(file, options)) : Files.newInputStream(file, options);
    }

    @Override
    public void applyTo(ByteInputSupport support) {
        support.setFileSource(this.asFileSource());
    }

    @Generated
    public boolean isGzipped() {
        return this.gzipped;
    }

    @Generated
    public void setGzipped(boolean gzipped) {
        this.gzipped = gzipped;
    }
}

