/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import lombok.Generated;
import nbbrd.console.picocli.JarPathHelper;
import nbbrd.io.sys.SystemProperties;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConfigHelper {
    @lombok.NonNull
    private final String appName;
    @lombok.NonNull
    private final SystemProperties system;
    @lombok.NonNull
    private final BiConsumer<Path, IOException> onLoadingError;

    public static @NonNull ConfigHelper of(@NonNull String appName) {
        return ConfigHelper.builder().appName(appName).build();
    }

    public static Builder builder() {
        return new Builder().system(SystemProperties.DEFAULT).onLoadingError(ConfigHelper::doNotReportError);
    }

    public void loadAll(@NonNull Properties config) {
        Objects.requireNonNull(config);
        for (Scope scope : Scope.values()) {
            this.loadFile(config, this.getConfigFile(scope));
        }
    }

    public void load(@NonNull Properties config, @NonNull Scope scope) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(scope);
        this.loadFile(config, this.getConfigFile(scope));
    }

    public void loadFile(@NonNull Properties properties, @Nullable Path file) {
        Objects.requireNonNull(properties);
        if (ConfigHelper.isValidFile(file)) {
            try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
                properties.load(stream);
            }
            catch (IOException ex) {
                this.onLoadingError.accept(file, ex);
            }
        }
    }

    private Path getConfigFile(Scope scope) {
        switch (scope) {
            case SYSTEM: {
                Predicate<Path> filterByAppName = path -> path.getFileName().toString().startsWith(this.appName);
                Path sibling = JarPathHelper.of(this.system).getJarPath(ConfigHelper.class, filterByAppName);
                return sibling != null ? sibling.getParent().resolve(this.getConfigFileName()) : null;
            }
            case GLOBAL: {
                Path parent = this.system.getUserHome();
                return parent != null ? parent.resolve(this.getConfigFileName()) : null;
            }
            case LOCAL: {
                Path parent = this.system.getUserDir();
                return parent != null ? parent.resolve(this.getConfigFileName()) : null;
            }
        }
        throw new RuntimeException();
    }

    private Path getConfigFileName() {
        return Paths.get(this.appName + ".properties", new String[0]);
    }

    static boolean isValidFile(@Nullable Path file) {
        return Objects.nonNull(file) && Files.exists(file, new LinkOption[0]) && Files.isReadable(file) && Files.isRegularFile(file, new LinkOption[0]);
    }

    static void doNotReportError(Path file, IOException error) {
    }

    @Generated
    ConfigHelper(@lombok.NonNull String appName, @lombok.NonNull SystemProperties system, @lombok.NonNull BiConsumer<Path, IOException> onLoadingError) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        if (system == null) {
            throw new NullPointerException("system is marked non-null but is null");
        }
        if (onLoadingError == null) {
            throw new NullPointerException("onLoadingError is marked non-null but is null");
        }
        this.appName = appName;
        this.system = system;
        this.onLoadingError = onLoadingError;
    }

    @Generated
    public static class Builder {
        @Generated
        private String appName;
        @Generated
        private SystemProperties system;
        @Generated
        private BiConsumer<Path, IOException> onLoadingError;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder appName(@lombok.NonNull String appName) {
            if (appName == null) {
                throw new NullPointerException("appName is marked non-null but is null");
            }
            this.appName = appName;
            return this;
        }

        @Generated
        public @NonNull Builder system(@lombok.NonNull SystemProperties system) {
            if (system == null) {
                throw new NullPointerException("system is marked non-null but is null");
            }
            this.system = system;
            return this;
        }

        @Generated
        public @NonNull Builder onLoadingError(@lombok.NonNull BiConsumer<Path, IOException> onLoadingError) {
            if (onLoadingError == null) {
                throw new NullPointerException("onLoadingError is marked non-null but is null");
            }
            this.onLoadingError = onLoadingError;
            return this;
        }

        @Generated
        public @NonNull ConfigHelper build() {
            return new ConfigHelper(this.appName, this.system, this.onLoadingError);
        }

        @Generated
        public @NonNull String toString() {
            return "ConfigHelper.Builder(appName=" + this.appName + ", system=" + this.system + ", onLoadingError=" + this.onLoadingError + ")";
        }
    }

    public static enum Scope {
        SYSTEM,
        GLOBAL,
        LOCAL;

    }
}

