/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs.cli;

import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Locale;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.text.TextInputSupport;

public class MarkdownInputSupport
extends TextInputSupport
implements DirectoryStream.Filter<Path> {
    @NonNull
    private Parser parser = Parser.builder().build();

    @SafeVarargs
    @NonNull
    public static MarkdownInputSupport newMarkdownInputSupport(CommandSupporter<? super MarkdownInputSupport> ... supporters) {
        if (supporters == null) {
            throw new NullPointerException("supporters is marked non-null but is null");
        }
        return CommandSupporter.create(MarkdownInputSupport::new, supporters);
    }

    public Document readDocument(Path file) throws IOException {
        try (BufferedReader reader = this.newBufferedReader(file);){
            Document document = this.parser.parseReader(reader);
            return document;
        }
    }

    public String getName(Path file) {
        return !this.isStdInFile(file) ? file.toString() : "stdin";
    }

    @Override
    public boolean accept(Path entry) throws IOException {
        return entry.toString().toLowerCase(Locale.ROOT).endsWith(".md");
    }

    @NonNull
    @Generated
    public Parser getParser() {
        return this.parser;
    }

    @Generated
    public void setParser(@NonNull Parser parser) {
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        this.parser = parser;
    }

    @Generated
    protected MarkdownInputSupport() {
    }
}

