/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;
import nbbrd.heylogs.Failure;
import nbbrd.heylogs.Status;
import nbbrd.heylogs.spi.Format;

public final class StylishFormat
implements Format {
    public static final String ID = "stylish";

    @Override
    @NonNull
    public String getId() {
        return ID;
    }

    @Override
    public void formatFailures(@NonNull Appendable appendable, @NonNull String source, @NonNull List<Failure> failures) throws IOException {
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (failures == null) {
            throw new NullPointerException("failures is marked non-null but is null");
        }
        appendable.append(source).append(System.lineSeparator());
        int l = failures.stream().mapToInt(failure -> StylishFormat.getNumberOfDigits(failure.getLine())).max().orElse(0);
        int c = failures.stream().mapToInt(failure -> StylishFormat.getNumberOfDigits(failure.getColumn())).max().orElse(0);
        int m = failures.stream().mapToInt(failure -> failure.getMessage().length()).max().orElse(0);
        for (Failure x : failures) {
            appendable.append(String.format(Locale.ROOT, "  %" + l + "d:%-" + c + "d  error  %-" + m + "s  %s", x.getLine(), x.getColumn(), x.getMessage(), x.getRuleId())).append(System.lineSeparator());
        }
        appendable.append(System.lineSeparator());
        switch (failures.size()) {
            case 0: {
                appendable.append("  No problem");
                break;
            }
            case 1: {
                appendable.append("  1 problem");
                break;
            }
            default: {
                appendable.append(String.format(Locale.ROOT, "  %d problems", failures.size()));
            }
        }
        appendable.append(System.lineSeparator());
    }

    private static int getNumberOfDigits(int number) {
        return (int)(Math.log10(number) + 1.0);
    }

    @Override
    public void formatStatus(@NonNull Appendable appendable, @NonNull String source, @NonNull Status status) throws IOException {
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        appendable.append(source);
        appendable.append(System.lineSeparator());
        if (status.getReleaseCount() == 0) {
            appendable.append("  No release found");
            appendable.append(System.lineSeparator());
        } else {
            appendable.append(String.format(Locale.ROOT, "  Found %d releases", status.getReleaseCount()));
            appendable.append(System.lineSeparator());
            appendable.append(String.format(Locale.ROOT, "  Ranging from %s to %s", status.getTimeRange().getFrom(), status.getTimeRange().getTo()));
            appendable.append(System.lineSeparator());
            if (status.isCompatibleWithSemver()) {
                appendable.append("  Compatible with Semantic Versioning").append(status.getSemverDetails());
                appendable.append(System.lineSeparator());
            } else {
                appendable.append("  Not compatible with Semantic Versioning");
                appendable.append(System.lineSeparator());
            }
        }
        appendable.append(status.isHasUnreleasedSection() ? "  Has an unreleased version" : "  Has no unreleased version");
        appendable.append(System.lineSeparator());
    }
}

