/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.util.ast.Node;
import lombok.NonNull;
import nbbrd.design.VisibleForTesting;
import nbbrd.heylogs.Failure;
import nbbrd.heylogs.Version;
import nbbrd.heylogs.spi.Rule;
import org.semver4j.Semver;

public final class SemverRule
implements Rule {
    @Override
    @NonNull
    public String getId() {
        return "semver";
    }

    @Override
    public Failure validate(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        return node instanceof Heading ? this.validateSemVer((Heading)node) : NO_PROBLEM;
    }

    @Override
    public boolean isAvailable() {
        return Rule.isEnabled(System.getProperties(), this.getId());
    }

    @VisibleForTesting
    Failure validateSemVer(Heading heading) {
        if (!Version.isVersionLevel(heading)) {
            return NO_PROBLEM;
        }
        try {
            Version version = Version.parse(heading);
            if (version.isUnreleased()) {
                return NO_PROBLEM;
            }
            String ref = version.getRef();
            return Semver.isValid(ref) ? NO_PROBLEM : Failure.builder().rule(this).message("Invalid semver format: '" + ref + "'").location(heading).build();
        }
        catch (IllegalArgumentException ex) {
            return NO_PROBLEM;
        }
    }
}

