/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.LinkNodeBase;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import nbbrd.design.VisibleForTesting;
import nbbrd.heylogs.Failure;
import nbbrd.heylogs.Nodes;
import nbbrd.heylogs.Util;
import nbbrd.heylogs.Version;
import nbbrd.heylogs.spi.Rule;
import nbbrd.heylogs.spi.RuleBatch;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum ExtendedRules implements Rule
{
    HTTPS{

        @Override
        public Failure validate(@NonNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked non-null but is null");
            }
            return node instanceof LinkNodeBase ? 1.validateHttps((LinkNodeBase)node) : NO_PROBLEM;
        }
    }
    ,
    GITHUB_ISSUE_REF{

        @Override
        public Failure validate(@NonNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked non-null but is null");
            }
            return node instanceof Link ? 2.validateGitHubIssueRef((Link)node) : NO_PROBLEM;
        }
    }
    ,
    CONSISTENT_SEPARATOR{

        @Override
        public @Nullable Failure validate(@NonNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked non-null but is null");
            }
            return node instanceof Document ? 3.validateConsistentSeparator((Document)node) : NO_PROBLEM;
        }
    };

    private static final int NO_ISSUE_REF = -1;

    @Override
    @NonNull
    public String getId() {
        return this.name().toLowerCase(Locale.ROOT).replace('_', '-');
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @VisibleForTesting
    static Failure validateHttps(LinkNodeBase link) {
        return Parser.onURL().parseValue(link.getUrl()).filter(url -> !url.getProtocol().equals("https")).map(ignore -> Failure.builder().rule(HTTPS).message("Expecting HTTPS protocol").location(link).build()).orElse(NO_PROBLEM);
    }

    @VisibleForTesting
    static Failure validateGitHubIssueRef(Link link) {
        int expected = ExtendedRules.getGitHubIssueRefFromURL(link);
        int found = ExtendedRules.getGitHubIssueRefFromText(link);
        return expected != -1 && found != -1 && expected != found ? Failure.builder().rule(GITHUB_ISSUE_REF).message("Expecting GitHub issue ref " + expected + ", found " + found).location(link).build() : NO_PROBLEM;
    }

    private static int getGitHubIssueRefFromURL(Link link) {
        int index;
        URL url = Parser.onURL().parse(link.getUrl());
        if (url != null && url.getHost().equals("github.com") && (index = url.getPath().indexOf("/issues/")) != -1) {
            return Parser.onInteger().parseValue(url.getPath().substring(index + 8)).orElse(-1);
        }
        return -1;
    }

    private static int getGitHubIssueRefFromText(Link link) {
        String text = link.getText().toString();
        if (text.startsWith("#")) {
            return Parser.onInteger().parseValue(text.substring(1)).orElse(-1);
        }
        return -1;
    }

    @VisibleForTesting
    static Failure validateConsistentSeparator(Document doc) {
        List separators = Nodes.of(Heading.class).descendants(doc).filter(Version::isVersionLevel).map(Util.illegalArgumentToNull(Version::parse)).filter(version -> version != null && !version.isUnreleased()).map(Version::getSeparator).distinct().collect(Collectors.toList());
        return separators.size() > 1 ? Failure.builder().rule(CONSISTENT_SEPARATOR).message("Expecting consistent version-date separator " + Util.toUnicode((Character)separators.get(0)) + ", found " + separators.stream().map(Util::toUnicode).collect(Collectors.joining(", ", "[", "]"))).location(doc).build() : NO_PROBLEM;
    }

    public static final class Batch
    implements RuleBatch {
        @Override
        public Stream<Rule> getProviders() {
            return Stream.of(ExtendedRules.values());
        }
    }
}

