/*
 * Decompiled with CFR 0.152.
 */
package internal.console.picocli.csv;

import internal.console.picocli.csv.ExcelCsv;
import nbbrd.console.picocli.Profilable;
import nbbrd.console.picocli.Profile;
import nbbrd.console.picocli.csv.CsvInputOptions;
import nbbrd.console.picocli.csv.CsvOutputOptions;
import nbbrd.console.picocli.text.ObsFormatOptions;

public final class ExcelProfile
implements Profile.Spi {
    private final ExcelCsv xl = ExcelCsv.INSTANCE;

    @Override
    public String getId() {
        return "excel";
    }

    @Override
    public void apply(Profilable profilable) {
        if (profilable instanceof CsvInputOptions) {
            this.applyOnCsvInput((CsvInputOptions)profilable);
        }
        if (profilable instanceof CsvOutputOptions) {
            this.applyOnCsvOutput((CsvOutputOptions)profilable);
        }
        if (profilable instanceof ObsFormatOptions) {
            this.applyOnObsFormat((ObsFormatOptions)profilable);
        }
    }

    private void applyOnObsFormat(ObsFormatOptions o) {
        o.setLocale(this.xl.getLocale());
        o.setDatePattern(this.xl.getDatePattern());
        o.setDatetimePattern(this.xl.getDateTimePattern());
        o.setIgnoreNumberGrouping(false);
    }

    private void applyOnCsvOutput(CsvOutputOptions o) {
        o.setDelimiter(this.xl.getDelimiter());
        o.setQuote(this.xl.getQuote());
        o.setSeparator(this.xl.getSeparator());
        o.setEncoding(this.xl.getEncoding());
    }

    private void applyOnCsvInput(CsvInputOptions o) {
        o.setDelimiter(this.xl.getDelimiter());
        o.setQuote(this.xl.getQuote());
        o.setSeparator(this.xl.getSeparator());
        o.setEncoding(this.xl.getEncoding());
    }
}

