/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.internal.range.processor;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.semver4j.Range;
import org.semver4j.internal.range.processor.Processor;
import org.semver4j.internal.range.processor.RangesUtils;

public class IvyProcessor
implements Processor {
    private static final Pattern PATTERN = Pattern.compile("^(\\[|\\]|\\()([0-9]+)?\\.?([0-9]+)?\\,([0-9]+)?\\.?([0-9]+)?(\\]|\\[|\\))$");

    @Override
    public String process(String range) {
        Matcher matcher = PATTERN.matcher(range);
        if (!matcher.matches()) {
            return range;
        }
        String fullRange = matcher.group(0);
        String openSign = matcher.group(1);
        int fromMajor = RangesUtils.parseIntWithXSupport(matcher.group(2));
        int fromMinor = RangesUtils.parseIntWithXSupport(matcher.group(3));
        int toMajor = RangesUtils.parseIntWithXSupport(matcher.group(4));
        int toMinor = RangesUtils.parseIntWithXSupport(matcher.group(5));
        String closeSign = matcher.group(6);
        if (RangesUtils.isX(fromMinor)) {
            fromMinor = 0;
        }
        if (RangesUtils.isX(toMinor)) {
            toMinor = 0;
        }
        boolean openInclusive = this.isInclusiveRange(openSign);
        boolean closeInclusive = this.isInclusiveRange(closeSign);
        if (openInclusive && closeInclusive) {
            if (openSign.equals("[") && closeSign.equals("]")) {
                return String.format(Locale.ROOT, "%s%d.%d.0 %s%d.%d.0", Range.RangeOperator.GTE.asString(), fromMajor, fromMinor, Range.RangeOperator.LTE.asString(), toMajor, toMinor);
            }
            if (openSign.equals("[") && closeSign.equals("[")) {
                return String.format(Locale.ROOT, "%s%d.%d.0 %s%d.%d.0", Range.RangeOperator.GTE.asString(), fromMajor, fromMinor, Range.RangeOperator.LT.asString(), toMajor, toMinor);
            }
            if (openSign.equals("]") && closeSign.equals("]")) {
                return String.format(Locale.ROOT, "%s%d.%d.0 %s%d.%d.0", Range.RangeOperator.GT.asString(), fromMajor, fromMinor, Range.RangeOperator.LTE.asString(), toMajor, toMinor);
            }
            if (openSign.equals("]") && closeSign.equals("[")) {
                return String.format(Locale.ROOT, "%s%d.%d.0 %s%d.%d.0", Range.RangeOperator.GT.asString(), fromMajor, fromMinor, Range.RangeOperator.LT.asString(), toMajor, toMinor);
            }
        } else if (closeSign.equals(")")) {
            if (openSign.equals("[")) {
                return String.format(Locale.ROOT, "%s%d.%d.0", Range.RangeOperator.GTE.asString(), fromMajor, fromMinor);
            }
            if (openSign.equals("]")) {
                return String.format(Locale.ROOT, "%s%d.%d.0", Range.RangeOperator.GT.asString(), fromMajor, fromMinor);
            }
        } else if (openSign.equals("(")) {
            if (closeSign.equals("]")) {
                return String.format(Locale.ROOT, "%s%d.%d.0", Range.RangeOperator.LTE.asString(), toMajor, toMinor);
            }
            if (closeSign.equals("[")) {
                return String.format(Locale.ROOT, "%s%d.%d.0", Range.RangeOperator.LT.asString(), toMajor, toMinor);
            }
        }
        return range;
    }

    private boolean isInclusiveRange(String character) {
        return character.equals("[") || character.equals("]");
    }
}

