/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.internal.range;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.semver4j.Range;
import org.semver4j.RangesList;
import org.semver4j.internal.Tokenizers;
import org.semver4j.internal.range.RangeProcessorPipeline;
import org.semver4j.internal.range.processor.CaretProcessor;
import org.semver4j.internal.range.processor.GreaterThanOrEqualZeroProcessor;
import org.semver4j.internal.range.processor.HyphenProcessor;
import org.semver4j.internal.range.processor.IvyProcessor;
import org.semver4j.internal.range.processor.TildeProcessor;
import org.semver4j.internal.range.processor.XRangeProcessor;

public class RangesListFactory {
    private static final Pattern pattern = Pattern.compile(Tokenizers.COMPARATOR);

    public static RangesList create(String range) {
        String[] rangeSections;
        range = range.trim();
        RangesList rangesList = new RangesList();
        for (String rangeSection : rangeSections = range.split("\\|\\|")) {
            rangeSection = RangesListFactory.applyProcessors(rangeSection);
            List<Range> ranges = RangesListFactory.addRanges(rangeSection);
            rangesList.add(ranges);
        }
        return rangesList;
    }

    private static String applyProcessors(String range) {
        return RangeProcessorPipeline.startWith(new GreaterThanOrEqualZeroProcessor()).addProcessor(new IvyProcessor()).addProcessor(new HyphenProcessor()).addProcessor(new CaretProcessor()).addProcessor(new TildeProcessor()).addProcessor(new XRangeProcessor()).process(range);
    }

    private static List<Range> addRanges(String range) {
        String[] parsedRanges;
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (String parsedRange : parsedRanges = range.split("\\s+")) {
            Matcher matcher = pattern.matcher(parsedRange);
            if (!matcher.matches()) continue;
            String rangeOperator = matcher.group(1);
            String version = matcher.group(2);
            ranges.add(new Range(version, Range.RangeOperator.value(rangeOperator)));
        }
        return ranges;
    }
}

