/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.semver4j.Range;
import org.semver4j.Semver;

public class RangesList {
    private final List<List<Range>> rangesList = new ArrayList<List<Range>>();

    public RangesList add(List<Range> ranges) {
        if (!ranges.isEmpty()) {
            this.rangesList.add(ranges);
        }
        return this;
    }

    public boolean isSatisfiedBy(Semver version) {
        return this.rangesList.stream().anyMatch(ranges -> this.isSingleSetOfRangesIsSatisfied((List<Range>)ranges, version));
    }

    public String toString() {
        return new StringJoiner(", ", RangesList.class.getSimpleName() + "[", "]").add("rangesList=" + this.rangesList).toString();
    }

    private boolean isSingleSetOfRangesIsSatisfied(List<Range> ranges, Semver version) {
        for (Range range : ranges) {
            if (range.isSatisfiedBy(version)) continue;
            return false;
        }
        if (!version.getPreRelease().isEmpty()) {
            for (Range range : ranges) {
                Semver rangeSemver = range.getRangeVersion();
                List<String> preRelease = rangeSemver.getPreRelease();
                if (preRelease.size() <= 0 || version.getMajor() != rangeSemver.getMajor() || version.getMinor() != rangeSemver.getMinor() || version.getPatch() != rangeSemver.getPatch()) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

