/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.cli;

import internal.heylogs.cli.PrintAndLogExceptionHandler;
import internal.heylogs.cli.SpecialProperties;
import java.util.Properties;
import java.util.concurrent.Callable;
import nbbrd.console.picocli.ConfigHelper;
import nbbrd.console.picocli.LoggerHelper;
import nbbrd.heylogs.About;
import nbbrd.heylogs.cli.CheckCommand;
import nbbrd.heylogs.cli.DebugCommand;
import nbbrd.heylogs.cli.ExtractCommand;
import nbbrd.heylogs.cli.ListCommand;
import nbbrd.heylogs.cli.ScanCommand;
import picocli.CommandLine;
import picocli.jansi.graalvm.AnsiConsole;

@CommandLine.Command(name="heylogs", versionProvider=ManifestVersionProvider.class, scope=CommandLine.ScopeType.INHERIT, sortOptions=false, mixinStandardHelpOptions=true, descriptionHeading="%n", parameterListHeading="%nParameters:%n", optionListHeading="%nOptions:%n", commandListHeading="%nCommands:%n", headerHeading="%n", subcommands={ScanCommand.class, ListCommand.class, CheckCommand.class, ExtractCommand.class, DebugCommand.class}, description={"Set of tools to deal with the @|bold keep-a-changelog|@ format.", "%nMore info at https://github.com/nbbrd/heylogs"})
public final class MainCommand
implements Callable<Void> {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    public static void main(String[] args) {
        SpecialProperties specialProperties = SpecialProperties.parse(args);
        if (!specialProperties.isNoConfig()) {
            ConfigHelper.of("heylogs").loadAll(System.getProperties());
        }
        LoggerHelper.disableDefaultConsoleLogger();
        System.exit(MainCommand.execMain(specialProperties, System.getProperties(), args));
    }

    private static int execMain(SpecialProperties specialProperties, Properties properties, String[] args) {
        specialProperties.apply(System.getProperties());
        try (AnsiConsole ignore = AnsiConsole.windowsInstall();){
            CommandLine cmd = new CommandLine(new MainCommand());
            cmd.setCaseInsensitiveEnumValuesAllowed(true);
            cmd.setDefaultValueProvider(new CommandLine.PropertiesDefaultProvider(properties));
            cmd.setExecutionExceptionHandler(new PrintAndLogExceptionHandler(MainCommand.class, specialProperties.isDebugRequired()));
            int n = cmd.execute(args);
            return n;
        }
    }

    @Override
    public Void call() {
        this.spec.commandLine().usage(this.spec.commandLine().getOut());
        return null;
    }

    public static final class ManifestVersionProvider
    implements CommandLine.IVersionProvider {
        @Override
        public String[] getVersion() {
            return new String[]{"@|bold heylogs " + About.VERSION + "|@", "JVM: ${java.version} (${java.vendor} ${java.vm.name} ${java.vm.version})", "OS: ${os.name} ${os.version} ${os.arch}"};
        }
    }
}

