/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.cli;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import internal.heylogs.cli.MarkdownInputSupport;
import internal.heylogs.cli.VersionFilterOptions;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.FileInputParameters;
import nbbrd.console.picocli.FileOutputOptions;
import nbbrd.console.picocli.text.TextOutputSupport;
import nbbrd.heylogs.Nodes;
import nbbrd.heylogs.Version;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List versions from changelog."})
public final class ListCommand
implements Callable<Void> {
    @CommandLine.Mixin
    private FileInputParameters input;
    @CommandLine.Mixin
    private FileOutputOptions output;
    @CommandLine.ArgGroup(heading="%nFilters:%n", exclusive=false)
    private final VersionFilterOptions filter = new VersionFilterOptions();

    @Override
    public Void call() throws Exception {
        this.store(this.list(this.load()));
        return null;
    }

    private Document load() throws IOException {
        return MarkdownInputSupport.newMarkdownInputSupport(new CommandSupporter[0]).readDocument(this.input.getFile());
    }

    private List<Heading> list(Node document) {
        return Nodes.of(Heading.class).descendants(document).filter(Version::isVersionLevel).filter(this.filter.get()::contains).limit(this.filter.getLimit()).collect(Collectors.toList());
    }

    private void store(List<Heading> list) throws IOException {
        try (BufferedWriter writer = TextOutputSupport.newTextOutputSupport(new CommandSupporter[0]).newBufferedWriter(this.output.getFile());){
            for (Heading item : list) {
                writer.append(item.getChars());
                writer.newLine();
            }
        }
    }
}

