/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.cli;

import com.vladsch.flexmark.util.ast.Document;
import internal.heylogs.cli.MarkdownInputSupport;
import internal.heylogs.cli.MarkdownOutputSupport;
import internal.heylogs.cli.VersionFilterOptions;
import java.io.IOException;
import java.util.concurrent.Callable;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.FileInputParameters;
import nbbrd.console.picocli.FileOutputOptions;
import picocli.CommandLine;

@CommandLine.Command(name="extract", description={"Extract versions from changelog."})
public final class ExtractCommand
implements Callable<Void> {
    @CommandLine.Mixin
    private FileInputParameters input;
    @CommandLine.Mixin
    private FileOutputOptions output;
    @CommandLine.ArgGroup(heading="%nFilters:%n", exclusive=false)
    private final VersionFilterOptions filter = new VersionFilterOptions();

    @Override
    public Void call() throws Exception {
        this.store(this.extract(this.load()));
        return null;
    }

    private Document load() throws IOException {
        return MarkdownInputSupport.newMarkdownInputSupport(new CommandSupporter[0]).readDocument(this.input.getFile());
    }

    private Document extract(Document document) {
        this.filter.get().apply(document);
        return document;
    }

    private void store(Document document) throws IOException {
        MarkdownOutputSupport.newMarkdownOutputSupport(new CommandSupporter[0]).writeDocument(this.output.getFile(), document);
    }
}

