/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.cli;

import internal.heylogs.cli.FailureFormatOptions;
import internal.heylogs.cli.MarkdownInputSupport;
import internal.heylogs.cli.RuleSetOptions;
import java.io.BufferedWriter;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.FileOutputOptions;
import nbbrd.console.picocli.MultiFileInputOptions;
import nbbrd.console.picocli.text.TextOutputSupport;
import nbbrd.heylogs.Failure;
import nbbrd.heylogs.FailureFormatter;
import nbbrd.heylogs.Rule;
import picocli.CommandLine;

@CommandLine.Command(name="check", description={"Check changelog format."})
public final class CheckCommand
implements Callable<Void> {
    @CommandLine.Mixin
    private MultiFileInputOptions input;
    @CommandLine.Mixin
    private FileOutputOptions output;
    @CommandLine.Mixin
    private RuleSetOptions ruleSet;
    @CommandLine.Mixin
    private FailureFormatOptions format;

    @Override
    public Void call() throws Exception {
        try (BufferedWriter writer = TextOutputSupport.newTextOutputSupport(new CommandSupporter[0]).newBufferedWriter(this.output.getFile());){
            List<Rule> rules = this.ruleSet.getRules();
            FailureFormatter formatter = this.format.getFormatter();
            MarkdownInputSupport markdown = MarkdownInputSupport.newMarkdownInputSupport(new CommandSupporter[0]);
            for (Path file : this.input.getAllFiles(markdown::accept)) {
                formatter.format(writer, markdown.getName(file), Failure.allOf(markdown.readDocument(file), rules));
            }
        }
        return null;
    }
}

