/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.RefNode;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.heylogs.Nodes;
import nbbrd.heylogs.TimeRange;
import nbbrd.heylogs.Version;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class VersionFilter {
    public static final VersionFilter DEFAULT = VersionFilter.builder().build();
    @NonNull
    private final String ref;
    @NonNull
    private final Pattern unreleasedPattern;
    @NonNull
    private final TimeRange timeRange;
    private final int limit;

    private boolean isUnreleasedPattern() {
        return this.unreleasedPattern.asPredicate().test(this.ref);
    }

    private boolean containsRef(Version version) {
        return this.isUnreleasedPattern() && version.isUnreleased() || version.getRef().contains(this.ref);
    }

    public boolean contains(Heading heading) {
        return this.contains(Version.parse(heading));
    }

    public boolean contains(Version version) {
        return this.containsRef(version) && this.timeRange.contains(version.getDate());
    }

    public void apply(Document root) {
        int found = 0;
        boolean keep = false;
        ArrayList refNodes = new ArrayList();
        ArrayList<Reference> references = new ArrayList<Reference>();
        for (Node current : root.getChildren()) {
            if (current instanceof Heading && Version.isVersionLevel((Heading)current)) {
                if (found >= this.getLimit() || !this.contains((Heading)current)) {
                    keep = false;
                } else {
                    ++found;
                    keep = true;
                }
            }
            if (keep) {
                Nodes.of(RefNode.class).descendants(current).map(node -> node.getReference().toString()).forEach(refNodes::add);
                continue;
            }
            if (current instanceof Reference) {
                references.add((Reference)current);
                continue;
            }
            current.unlink();
        }
        references.stream().filter(reference -> !refNodes.contains(reference.getReference().toString())).forEach(Node::unlink);
    }

    public static LocalDate parseLocalDate(CharSequence input) {
        try {
            return Year.parse(input).atDay(1);
        }
        catch (Exception ex1) {
            try {
                return YearMonth.parse(input).atDay(1);
            }
            catch (Exception ex2) {
                return LocalDate.parse(input);
            }
        }
    }

    @Generated
    private static String $default$ref() {
        return "";
    }

    @Generated
    private static Pattern $default$unreleasedPattern() {
        return Pattern.compile("^.*-SNAPSHOT$");
    }

    @Generated
    private static TimeRange $default$timeRange() {
        return TimeRange.ALL;
    }

    @Generated
    private static int $default$limit() {
        return Integer.MAX_VALUE;
    }

    @Generated
    VersionFilter(@NonNull String ref, @NonNull Pattern unreleasedPattern, @NonNull TimeRange timeRange, int limit) {
        if (ref == null) {
            throw new NullPointerException("ref is marked non-null but is null");
        }
        if (unreleasedPattern == null) {
            throw new NullPointerException("unreleasedPattern is marked non-null but is null");
        }
        if (timeRange == null) {
            throw new NullPointerException("timeRange is marked non-null but is null");
        }
        this.ref = ref;
        this.unreleasedPattern = unreleasedPattern;
        this.timeRange = timeRange;
        this.limit = limit;
    }

    @Generated
    public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
        return new Builder();
    }

    @NonNull
    @Generated
    public String getRef() {
        return this.ref;
    }

    @NonNull
    @Generated
    public Pattern getUnreleasedPattern() {
        return this.unreleasedPattern;
    }

    @NonNull
    @Generated
    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionFilter)) {
            return false;
        }
        VersionFilter other = (VersionFilter)o;
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
            return false;
        }
        Pattern this$unreleasedPattern = this.getUnreleasedPattern();
        Pattern other$unreleasedPattern = other.getUnreleasedPattern();
        if (this$unreleasedPattern == null ? other$unreleasedPattern != null : !this$unreleasedPattern.equals(other$unreleasedPattern)) {
            return false;
        }
        TimeRange this$timeRange = this.getTimeRange();
        TimeRange other$timeRange = other.getTimeRange();
        return !(this$timeRange == null ? other$timeRange != null : !((Object)this$timeRange).equals(other$timeRange));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLimit();
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        Pattern $unreleasedPattern = this.getUnreleasedPattern();
        result = result * 59 + ($unreleasedPattern == null ? 43 : $unreleasedPattern.hashCode());
        TimeRange $timeRange = this.getTimeRange();
        result = result * 59 + ($timeRange == null ? 43 : ((Object)$timeRange).hashCode());
        return result;
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
        return "VersionFilter(ref=" + this.getRef() + ", unreleasedPattern=" + this.getUnreleasedPattern() + ", timeRange=" + this.getTimeRange() + ", limit=" + this.getLimit() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean ref$set;
        @Generated
        private String ref$value;
        @Generated
        private boolean unreleasedPattern$set;
        @Generated
        private Pattern unreleasedPattern$value;
        @Generated
        private boolean timeRange$set;
        @Generated
        private TimeRange timeRange$value;
        @Generated
        private boolean limit$set;
        @Generated
        private int limit$value;

        @Generated
        Builder() {
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder ref(@NonNull String ref) {
            if (ref == null) {
                throw new NullPointerException("ref is marked non-null but is null");
            }
            this.ref$value = ref;
            this.ref$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder unreleasedPattern(@NonNull Pattern unreleasedPattern) {
            if (unreleasedPattern == null) {
                throw new NullPointerException("unreleasedPattern is marked non-null but is null");
            }
            this.unreleasedPattern$value = unreleasedPattern;
            this.unreleasedPattern$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder timeRange(@NonNull TimeRange timeRange) {
            if (timeRange == null) {
                throw new NullPointerException("timeRange is marked non-null but is null");
            }
            this.timeRange$value = timeRange;
            this.timeRange$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder limit(int limit) {
            this.limit$value = limit;
            this.limit$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull VersionFilter build() {
            String ref$value = this.ref$value;
            if (!this.ref$set) {
                ref$value = VersionFilter.$default$ref();
            }
            Pattern unreleasedPattern$value = this.unreleasedPattern$value;
            if (!this.unreleasedPattern$set) {
                unreleasedPattern$value = VersionFilter.$default$unreleasedPattern();
            }
            TimeRange timeRange$value = this.timeRange$value;
            if (!this.timeRange$set) {
                timeRange$value = VersionFilter.$default$timeRange();
            }
            int limit$value = this.limit$value;
            if (!this.limit$set) {
                limit$value = VersionFilter.$default$limit();
            }
            return new VersionFilter(ref$value, unreleasedPattern$value, timeRange$value, limit$value);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "VersionFilter.Builder(ref$value=" + this.ref$value + ", unreleasedPattern$value=" + this.unreleasedPattern$value + ", timeRange$value=" + this.timeRange$value + ", limit$value=" + this.limit$value + ")";
        }
    }
}

