/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import internal.heylogs.SummaryStatistics;
import java.time.LocalDate;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TimeRange {
    public static final TimeRange ALL = TimeRange.of(LocalDate.MIN, LocalDate.MAX);
    @lombok.NonNull
    private final LocalDate from;
    @lombok.NonNull
    private final LocalDate to;

    public static Collector<LocalDate, ?, Optional<TimeRange>> toTimeRange() {
        Collector summarizing = SummaryStatistics.summarizing();
        return Collectors.collectingAndThen(summarizing, TimeRange::of);
    }

    private static Optional<TimeRange> of(SummaryStatistics<LocalDate> stats) {
        return stats.getCount() == 0L ? Optional.empty() : Optional.of(new TimeRange(stats.getMin(), stats.getMax()));
    }

    public boolean contains(LocalDate date) {
        return this.from.compareTo(date) <= 0 && date.compareTo(this.to) <= 0;
    }

    @Generated
    private TimeRange(@lombok.NonNull LocalDate from, @lombok.NonNull LocalDate to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        this.from = from;
        this.to = to;
    }

    @Generated
    public static @NonNull TimeRange of(@lombok.NonNull LocalDate from, @lombok.NonNull LocalDate to) {
        return new TimeRange(from, to);
    }

    @lombok.NonNull
    @Generated
    public LocalDate getFrom() {
        return this.from;
    }

    @lombok.NonNull
    @Generated
    public LocalDate getTo() {
        return this.to;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeRange)) {
            return false;
        }
        TimeRange other = (TimeRange)o;
        LocalDate this$from = this.getFrom();
        LocalDate other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        LocalDate this$to = this.getTo();
        LocalDate other$to = other.getTo();
        return !(this$to == null ? other$to != null : !((Object)this$to).equals(other$to));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        LocalDate $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "TimeRange(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }
}

