/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.util.ast.Node;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import nbbrd.heylogs.Nodes;
import nbbrd.heylogs.TimeRange;
import nbbrd.heylogs.Version;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.semver4j.Semver;

public final class Scan {
    private final int releaseCount;
    private final TimeRange timeRange;
    private final boolean compatibleWithSemver;
    private final String semverDetails;
    private final boolean hasUnreleasedSection;

    public static Scan of(Node document) {
        Map<Boolean, List<Version>> versionByType = Nodes.of(Heading.class).descendants(document).filter(Version::isVersionLevel).map(Scan::parseVersionOrNull).filter(Objects::nonNull).collect(Collectors.partitioningBy(Version::isUnreleased));
        boolean compatibleWithSemver = Scan.isCompatibleWithSemver(versionByType.get(false));
        return new Scan(versionByType.get(false).size(), versionByType.get(false).stream().map(Version::getDate).collect(TimeRange.toTimeRange()).orElse(TimeRange.ALL), compatibleWithSemver, compatibleWithSemver ? Scan.getDetails(versionByType.get(false)) : "", versionByType.containsKey(true));
    }

    private static Version parseVersionOrNull(Heading heading) {
        try {
            return Version.parse(heading);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private static boolean isCompatibleWithSemver(List<Version> releases) {
        return releases.stream().map(Version::getRef).allMatch(Semver::isValid);
    }

    private static String getDetails(List<Version> releases) {
        List semvers = releases.stream().map(Version::getRef).map(Semver::parse).collect(Collectors.toList());
        SortedMap diffs = IntStream.range(1, semvers.size()).mapToObj(i -> ((Semver)semvers.get(i)).diff((Semver)semvers.get(i - 1))).collect(Collectors.groupingBy(o -> o, TreeMap::new, Collectors.toList()));
        return diffs.entrySet().stream().map(entry -> ((List)entry.getValue()).size() + " " + ((Semver.VersionDiff)((Object)((Object)entry.getKey()))).toString()).collect(Collectors.joining(", ", " (", ")"));
    }

    @Generated
    public Scan(int releaseCount, TimeRange timeRange, boolean compatibleWithSemver, String semverDetails, boolean hasUnreleasedSection) {
        this.releaseCount = releaseCount;
        this.timeRange = timeRange;
        this.compatibleWithSemver = compatibleWithSemver;
        this.semverDetails = semverDetails;
        this.hasUnreleasedSection = hasUnreleasedSection;
    }

    @Generated
    public int getReleaseCount() {
        return this.releaseCount;
    }

    @Generated
    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    @Generated
    public boolean isCompatibleWithSemver() {
        return this.compatibleWithSemver;
    }

    @Generated
    public String getSemverDetails() {
        return this.semverDetails;
    }

    @Generated
    public boolean isHasUnreleasedSection() {
        return this.hasUnreleasedSection;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Scan)) {
            return false;
        }
        Scan other = (Scan)o;
        if (this.getReleaseCount() != other.getReleaseCount()) {
            return false;
        }
        if (this.isCompatibleWithSemver() != other.isCompatibleWithSemver()) {
            return false;
        }
        if (this.isHasUnreleasedSection() != other.isHasUnreleasedSection()) {
            return false;
        }
        TimeRange this$timeRange = this.getTimeRange();
        TimeRange other$timeRange = other.getTimeRange();
        if (this$timeRange == null ? other$timeRange != null : !((Object)this$timeRange).equals(other$timeRange)) {
            return false;
        }
        String this$semverDetails = this.getSemverDetails();
        String other$semverDetails = other.getSemverDetails();
        return !(this$semverDetails == null ? other$semverDetails != null : !this$semverDetails.equals(other$semverDetails));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReleaseCount();
        result = result * 59 + (this.isCompatibleWithSemver() ? 79 : 97);
        result = result * 59 + (this.isHasUnreleasedSection() ? 79 : 97);
        TimeRange $timeRange = this.getTimeRange();
        result = result * 59 + ($timeRange == null ? 43 : ((Object)$timeRange).hashCode());
        String $semverDetails = this.getSemverDetails();
        result = result * 59 + ($semverDetails == null ? 43 : $semverDetails.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "Scan(releaseCount=" + this.getReleaseCount() + ", timeRange=" + this.getTimeRange() + ", compatibleWithSemver=" + this.isCompatibleWithSemver() + ", semverDetails=" + this.getSemverDetails() + ", hasUnreleasedSection=" + this.isHasUnreleasedSection() + ")";
    }
}

