/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import nbbrd.heylogs.BaseSection;

public enum Changelog implements BaseSection
{
    INSTANCE;

    private static final int HEADING_LEVEL = 1;

    public static Changelog parse(Heading heading) {
        if (!Changelog.isChangelogLevel(heading)) {
            throw new IllegalArgumentException("Invalid heading level");
        }
        if (!"Changelog".contentEquals(heading.getText())) {
            throw new IllegalArgumentException("Invalid text");
        }
        return INSTANCE;
    }

    @Override
    public Heading toHeading() {
        Heading result = new Heading();
        result.setOpeningMarker(BasedSequence.repeatOf("#", 1));
        result.setLevel(1);
        result.appendChild(new Text(BasedSequence.of("Changelog")));
        return result;
    }

    public static boolean isChangelogLevel(Heading heading) {
        return heading.getLevel() == 1;
    }
}

