/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli.text;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Path;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.console.picocli.ByteOutputSupport;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.text.CharsetSupplier;
import nbbrd.io.text.TextBuffers;

public class TextOutputSupport
extends ByteOutputSupport {
    @NonNull
    private CharsetSupplier fileEncoding = CharsetSupplier.getDefault();
    @NonNull
    private CharsetSupplier stdoutEncoding = CharsetSupplier.ofStdout();

    @SafeVarargs
    @NonNull
    public static TextOutputSupport newTextOutputSupport(CommandSupporter<? super TextOutputSupport> ... supporters) {
        if (supporters == null) {
            throw new NullPointerException("supporters is marked non-null but is null");
        }
        return CommandSupporter.create(TextOutputSupport::new, supporters);
    }

    @NonNull
    public CharsetEncoder newEncoder(@NonNull Path file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return (this.isStdoutFile(file) ? this.stdoutEncoding.getCharset() : this.fileEncoding.getCharset()).newEncoder();
    }

    @NonNull
    public BufferedWriter newBufferedWriter(@NonNull Path file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        CharsetEncoder encoder = this.newEncoder(file);
        return new BufferedWriter(this.newOutputStreamWriter(file, encoder), this.getCharBufferSize(file, encoder));
    }

    public void writeString(@NonNull Path file, @NonNull String text) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        try (BufferedWriter writer = this.newBufferedWriter(file);){
            writer.write(text);
        }
    }

    protected OutputStreamWriter newOutputStreamWriter(Path file, CharsetEncoder encoder) throws IOException {
        return new OutputStreamWriter(this.newOutputStream(file), encoder);
    }

    protected int getCharBufferSize(Path file, CharsetEncoder encoder) throws IOException {
        return (this.isStdoutFile(file) ? TextBuffers.UNKNOWN : TextBuffers.of(file, encoder)).getCharBufferSize();
    }

    @NonNull
    @Generated
    public CharsetSupplier getFileEncoding() {
        return this.fileEncoding;
    }

    @NonNull
    @Generated
    public CharsetSupplier getStdoutEncoding() {
        return this.stdoutEncoding;
    }

    @Generated
    public void setFileEncoding(@NonNull CharsetSupplier fileEncoding) {
        if (fileEncoding == null) {
            throw new NullPointerException("fileEncoding is marked non-null but is null");
        }
        this.fileEncoding = fileEncoding;
    }

    @Generated
    public void setStdoutEncoding(@NonNull CharsetSupplier stdoutEncoding) {
        if (stdoutEncoding == null) {
            throw new NullPointerException("stdoutEncoding is marked non-null but is null");
        }
        this.stdoutEncoding = stdoutEncoding;
    }

    @Generated
    protected TextOutputSupport() {
    }
}

