/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli.text;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import lombok.Generated;
import nbbrd.console.picocli.Profilable;
import nbbrd.console.picocli.StandardCharsetCandidates;
import nbbrd.console.picocli.text.TextOutput;
import nbbrd.console.properties.ConsoleProperties;
import picocli.CommandLine;

public class TextOutputOptions
implements TextOutput,
Profilable {
    @CommandLine.Option(names={"-o", "--output"}, paramLabel="<file>", description={"Output to a file instead of stdout."})
    private Path file;
    @CommandLine.Option(names={"-z", "--gzipped"}, description={"Compress the output file with gzip."}, defaultValue="false")
    private boolean gzipped;
    @CommandLine.Option(names={"--append"}, description={"Append to the end of the output file."}, defaultValue="false")
    private boolean append;
    @CommandLine.Option(names={"-e", "--encoding"}, paramLabel="<encoding>", description={"Charset used to encode text."}, completionCandidates=StandardCharsetCandidates.class, defaultValue="UTF-8")
    private Charset encoding;

    @Override
    public OutputStream getStdOutStream() {
        return System.out;
    }

    @Override
    public Charset getStdOutEncoding() {
        return ConsoleProperties.ofServiceLoader().getStdOutEncoding().orElse(StandardCharsets.UTF_8);
    }

    @Override
    @Generated
    public Path getFile() {
        return this.file;
    }

    @Override
    @Generated
    public boolean isGzipped() {
        return this.gzipped;
    }

    @Override
    @Generated
    public boolean isAppend() {
        return this.append;
    }

    @Override
    @Generated
    public Charset getEncoding() {
        return this.encoding;
    }

    @Generated
    public void setFile(Path file) {
        this.file = file;
    }

    @Generated
    public void setGzipped(boolean gzipped) {
        this.gzipped = gzipped;
    }

    @Generated
    public void setAppend(boolean append) {
        this.append = append;
    }

    @Generated
    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }
}

