/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import lombok.Generated;
import nbbrd.console.picocli.text.TextInputSupport;

public interface TextInput {
    public Path getFile();

    public boolean isGzipped();

    public Charset getEncoding();

    public InputStream getStdInStream();

    public Charset getStdInEncoding();

    default public Reader newCharReader() throws IOException {
        if (this.hasFile()) {
            InputStream stream = Files.newInputStream(this.getFile(), new OpenOption[0]);
            return new InputStreamReader(this.isGzippedFile() ? new GZIPInputStream(stream) : stream, this.getEncoding());
        }
        return new InputStreamReader((InputStream)new UncloseableInputStream(this.getStdInStream()), this.getStdInEncoding());
    }

    default public String readString() throws IOException {
        try (Reader reader = this.newCharReader();){
            String string = TextInputSupport.readString(reader);
            return string;
        }
    }

    default public boolean hasFile() {
        return this.getFile() != null;
    }

    default public boolean isGzippedFile() {
        return this.hasFile() && (this.isGzipped() || this.getFile().toString().toLowerCase(Locale.ROOT).endsWith(".gz"));
    }

    public static final class UncloseableInputStream
    extends InputStream {
        private final InputStream delegate;

        @Generated
        public UncloseableInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        @Generated
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        @Generated
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        @Override
        @Generated
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        @Generated
        public byte[] readAllBytes() throws IOException {
            return this.delegate.readAllBytes();
        }

        @Override
        @Generated
        public byte[] readNBytes(int len) throws IOException {
            return this.delegate.readNBytes(len);
        }

        @Override
        @Generated
        public int readNBytes(byte[] b, int off, int len) throws IOException {
            return this.delegate.readNBytes(b, off, len);
        }

        @Override
        @Generated
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        @Generated
        public void skipNBytes(long n) throws IOException {
            this.delegate.skipNBytes(n);
        }

        @Override
        @Generated
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        @Generated
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        @Generated
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        @Generated
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        @Override
        @Generated
        public long transferTo(OutputStream out) throws IOException {
            return this.delegate.transferTo(out);
        }
    }
}

