/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli.csv;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Path;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.text.TextOutputSupport;
import nbbrd.picocsv.Csv;

public class PicocsvOutputSupport
extends TextOutputSupport {
    @NonNull
    private Csv.Format format = Csv.Format.DEFAULT;
    @NonNull
    private Csv.WriterOptions options = Csv.WriterOptions.DEFAULT;

    @SafeVarargs
    @NonNull
    public static PicocsvOutputSupport newPicocsvOutputSupport(CommandSupporter<? super PicocsvOutputSupport> ... supporters) {
        if (supporters == null) {
            throw new NullPointerException("supporters is marked non-null but is null");
        }
        return CommandSupporter.create(PicocsvOutputSupport::new, supporters);
    }

    @NonNull
    public Csv.Writer newCsvWriter(@NonNull Path file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        CharsetEncoder encoder = this.newEncoder(file);
        return Csv.Writer.of((Csv.Format)this.getFormat(), (Csv.WriterOptions)this.getOptions(), (Writer)this.newOutputStreamWriter(file, encoder), (int)this.getCharBufferSize(file, encoder));
    }

    @NonNull
    @Generated
    public Csv.Format getFormat() {
        return this.format;
    }

    @NonNull
    @Generated
    public Csv.WriterOptions getOptions() {
        return this.options;
    }

    @Generated
    public void setFormat(@NonNull Csv.Format format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.format = format;
    }

    @Generated
    public void setOptions(@NonNull Csv.WriterOptions options) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.options = options;
    }

    @Generated
    protected PicocsvOutputSupport() {
    }
}

