/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.FileSink;
import nbbrd.console.picocli.StdoutSink;

public class ByteOutputSupport {
    public static final String DEFAULT_STDOUT_FILE = "-";
    @NonNull
    private Path stdoutFile = Paths.get("-", new String[0]);
    @NonNull
    private StdoutSink stdoutSink = StdoutSink.getDefault();
    @NonNull
    private FileSink fileSink = FileSink.getDefault();
    private boolean append = false;

    @SafeVarargs
    @NonNull
    public static ByteOutputSupport newByteOutputSupport(CommandSupporter<? super ByteOutputSupport> ... supporters) {
        if (supporters == null) {
            throw new NullPointerException("supporters is marked non-null but is null");
        }
        return CommandSupporter.create(ByteOutputSupport::new, supporters);
    }

    public boolean isStdoutFile(@NonNull Path file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return file.equals(this.getStdoutFile());
    }

    public boolean isAppending(@NonNull Path file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return !this.isStdoutFile(file) && this.isAppend() && Files.exists(file, new LinkOption[0]) && Files.size(file) > 0L;
    }

    @NonNull
    public OutputStream newOutputStream(@NonNull Path file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return this.isStdoutFile(file) ? this.getStdoutSink().newOutputStream() : this.getFileSink().newOutputStream(file, StandardOpenOption.WRITE, StandardOpenOption.CREATE, this.isAppend() ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);
    }

    @NonNull
    @Generated
    public Path getStdoutFile() {
        return this.stdoutFile;
    }

    @NonNull
    @Generated
    public StdoutSink getStdoutSink() {
        return this.stdoutSink;
    }

    @NonNull
    @Generated
    public FileSink getFileSink() {
        return this.fileSink;
    }

    @Generated
    public boolean isAppend() {
        return this.append;
    }

    @Generated
    public void setStdoutFile(@NonNull Path stdoutFile) {
        if (stdoutFile == null) {
            throw new NullPointerException("stdoutFile is marked non-null but is null");
        }
        this.stdoutFile = stdoutFile;
    }

    @Generated
    public void setStdoutSink(@NonNull StdoutSink stdoutSink) {
        if (stdoutSink == null) {
            throw new NullPointerException("stdoutSink is marked non-null but is null");
        }
        this.stdoutSink = stdoutSink;
    }

    @Generated
    public void setFileSink(@NonNull FileSink fileSink) {
        if (fileSink == null) {
            throw new NullPointerException("fileSink is marked non-null but is null");
        }
        this.fileSink = fileSink;
    }

    @Generated
    public void setAppend(boolean append) {
        this.append = append;
    }

    @Generated
    protected ByteOutputSupport() {
    }
}

