/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.FileSource;
import nbbrd.console.picocli.StdinSource;

public class ByteInputSupport {
    public static final String DEFAULT_STDIN_FILE = "-";
    @NonNull
    private Path stdinFile = Paths.get("-", new String[0]);
    @NonNull
    private StdinSource stdinSource = StdinSource.getDefault();
    @NonNull
    private FileSource fileSource = FileSource.getDefault();

    @SafeVarargs
    @NonNull
    public static ByteInputSupport newByteInputSupport(CommandSupporter<? super ByteInputSupport> ... supporters) {
        if (supporters == null) {
            throw new NullPointerException("supporters is marked non-null but is null");
        }
        return CommandSupporter.create(ByteInputSupport::new, supporters);
    }

    public boolean isStdInFile(@NonNull Path file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return file.equals(this.getStdinFile());
    }

    @NonNull
    public InputStream newInputStream(@NonNull Path file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return this.isStdInFile(file) ? this.getStdinSource().newInputStream() : this.getFileSource().newInputStream(file, StandardOpenOption.READ);
    }

    @NonNull
    @Generated
    public Path getStdinFile() {
        return this.stdinFile;
    }

    @NonNull
    @Generated
    public StdinSource getStdinSource() {
        return this.stdinSource;
    }

    @NonNull
    @Generated
    public FileSource getFileSource() {
        return this.fileSource;
    }

    @Generated
    public void setStdinFile(@NonNull Path stdinFile) {
        if (stdinFile == null) {
            throw new NullPointerException("stdinFile is marked non-null but is null");
        }
        this.stdinFile = stdinFile;
    }

    @Generated
    public void setStdinSource(@NonNull StdinSource stdinSource) {
        if (stdinSource == null) {
            throw new NullPointerException("stdinSource is marked non-null but is null");
        }
        this.stdinSource = stdinSource;
    }

    @Generated
    public void setFileSource(@NonNull FileSource fileSource) {
        if (fileSource == null) {
            throw new NullPointerException("fileSource is marked non-null but is null");
        }
        this.fileSource = fileSource;
    }

    @Generated
    protected ByteInputSupport() {
    }
}

