/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs.cli;

import java.time.LocalDate;
import java.util.regex.Pattern;
import lombok.Generated;
import nbbrd.heylogs.TimeRange;
import nbbrd.heylogs.VersionFilter;
import picocli.CommandLine;

public class VersionFilterOptions {
    @CommandLine.Option(names={"-r", "--ref"}, paramLabel="<ref>", description={"Filter versions by name."})
    private String ref = VersionFilter.DEFAULT.getRef();
    @CommandLine.Option(names={"-u", "--unreleased"}, paramLabel="<pattern>", description={"Assume that versions that match this pattern are unreleased."})
    private Pattern unreleasedPattern = VersionFilter.DEFAULT.getUnreleasedPattern();
    @CommandLine.Option(names={"-f", "--from"}, paramLabel="<date>", description={"Filter versions by min date (included)."}, converter={LenientDateConverter.class})
    private LocalDate from = VersionFilter.DEFAULT.getTimeRange().getFrom();
    @CommandLine.Option(names={"-t", "--to"}, paramLabel="<date>", description={"Filter versions by max date (included)."}, converter={LenientDateConverter.class})
    private LocalDate to = VersionFilter.DEFAULT.getTimeRange().getTo();
    @CommandLine.Option(names={"-l", "--limit"}, description={"Limit the number of versions."})
    private int limit = VersionFilter.DEFAULT.getLimit();

    public VersionFilter get() {
        return VersionFilter.builder().ref(this.ref).unreleasedPattern(this.unreleasedPattern).timeRange(TimeRange.of(this.from, this.to)).limit(this.limit).build();
    }

    @Generated
    public String getRef() {
        return this.ref;
    }

    @Generated
    public Pattern getUnreleasedPattern() {
        return this.unreleasedPattern;
    }

    @Generated
    public LocalDate getFrom() {
        return this.from;
    }

    @Generated
    public LocalDate getTo() {
        return this.to;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public void setRef(String ref) {
        this.ref = ref;
    }

    @Generated
    public void setUnreleasedPattern(Pattern unreleasedPattern) {
        this.unreleasedPattern = unreleasedPattern;
    }

    @Generated
    public void setFrom(LocalDate from) {
        this.from = from;
    }

    @Generated
    public void setTo(LocalDate to) {
        this.to = to;
    }

    @Generated
    public void setLimit(int limit) {
        this.limit = limit;
    }

    private static final class LenientDateConverter
    implements CommandLine.ITypeConverter<LocalDate> {
        private LenientDateConverter() {
        }

        @Override
        public LocalDate convert(String value) {
            return VersionFilter.parseLocalDate(value);
        }
    }
}

