/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs.cli;

import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.util.ast.Document;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Path;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.console.picocli.CommandSupporter;
import nbbrd.console.picocli.text.TextOutputSupport;

public class MarkdownOutputSupport
extends TextOutputSupport {
    @NonNull
    private Formatter formatter = Formatter.builder().build();

    @SafeVarargs
    @NonNull
    public static MarkdownOutputSupport newMarkdownOutputSupport(CommandSupporter<? super MarkdownOutputSupport> ... supporters) {
        if (supporters == null) {
            throw new NullPointerException("supporters is marked non-null but is null");
        }
        return CommandSupporter.create(MarkdownOutputSupport::new, supporters);
    }

    public void writeDocument(Path file, Document document) throws IOException {
        try (BufferedWriter writer = this.newBufferedWriter(file);){
            this.formatter.render(document, writer);
        }
    }

    @NonNull
    @Generated
    public Formatter getFormatter() {
        return this.formatter;
    }

    @Generated
    public void setFormatter(@NonNull Formatter formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        this.formatter = formatter;
    }

    @Generated
    protected MarkdownOutputSupport() {
    }
}

