/*
 * Decompiled with CFR 0.152.
 */
package internal.console.properties.x;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import nbbrd.io.sys.ProcessReader;

final class Utils {
    @Generated
    private static final Logger log = Logger.getLogger(Utils.class.getName());
    static final int QUICK_RANK = 10;
    static final int NORMAL_RANK = 20;
    static final int SLOW_RANK = 30;
    static final String MSYSTEM_ENV = "MSYSTEM";
    static final String TERM_ENV = "TERM";

    static boolean isCygwin(UnaryOperator<String> env) {
        return env.apply("PWD") != null && ((String)env.apply("PWD")).startsWith("/") && !"cygwin".equals(env.apply(TERM_ENV));
    }

    static boolean isMingwXterm(UnaryOperator<String> env) {
        return env.apply(MSYSTEM_ENV) != null && ((String)env.apply(MSYSTEM_ENV)).startsWith("MINGW") && Utils.isXterm(env);
    }

    static boolean isXterm(UnaryOperator<String> env) {
        return "xterm".equals(env.apply(TERM_ENV));
    }

    static Optional<String> execToString(BiConsumer<IOException, String[]> onError, String ... command) {
        try {
            return Optional.of(ProcessReader.readToString(new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.INHERIT).start()));
        }
        catch (IOException ex) {
            onError.accept(ex, command);
            return Optional.empty();
        }
    }

    static void logCommandException(IOException ex, String[] command) {
        if (log.isLoggable(Level.WARNING)) {
            log.log(Level.WARNING, "Failed to execute command: " + Arrays.toString(command), ex);
        }
    }

    @Generated
    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

