/*
 * Decompiled with CFR 0.152.
 */
package internal.console.properties.x;

import internal.console.properties.x.Utils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.function.BiConsumer;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.console.properties.ConsoleProperties;
import nbbrd.io.sys.OS;

public final class TputConsoleProvider
implements ConsoleProperties.Spi {
    @NonNull
    private final BiConsumer<IOException, String[]> onError;

    public TputConsoleProvider() {
        this(Utils::logCommandException);
    }

    @Override
    public boolean isAvailable() {
        switch (OS.NAME) {
            case MACOS: 
            case LINUX: 
            case SOLARIS: {
                return Utils.isXterm(System::getenv);
            }
            case WINDOWS: {
                return Utils.isMingwXterm(System::getenv);
            }
        }
        return false;
    }

    @Override
    public int getRank() {
        return 20;
    }

    @Override
    public Charset getStdInEncodingOrNull() {
        return null;
    }

    @Override
    public Charset getStdOutEncodingOrNull() {
        return null;
    }

    @Override
    public int getColumns() {
        return this.execTput("cols").map(Integer::valueOf).orElse(-1);
    }

    @Override
    public int getRows() {
        return this.execTput("lines").map(Integer::valueOf).orElse(-1);
    }

    private Optional<String> execTput(String command) {
        return Utils.execToString(this.onError, "tput", command);
    }

    @Generated
    TputConsoleProvider(@NonNull BiConsumer<IOException, String[]> onError) {
        if (onError == null) {
            throw new NullPointerException("onError is marked non-null but is null");
        }
        this.onError = onError;
    }
}

