/*
 * Decompiled with CFR 0.152.
 */
package internal.console.properties.x;

import internal.console.properties.x.Utils;
import internal.console.properties.x.WhichWrapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.console.properties.ConsoleProperties;
import nbbrd.io.sys.OS;

public final class PowerShellConsoleProvider
implements ConsoleProperties.Spi {
    @NonNull
    private final BiConsumer<IOException, String[]> onError;
    private final AtomicReference<Object> executable = new AtomicReference();
    private static final String WIN_EXECUTABLE = "powershell";
    private static final String CORE_EXECUTABLE = "pwsh";

    public PowerShellConsoleProvider() {
        this(Utils::logCommandException);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getRank() {
        return 30;
    }

    @Override
    public Charset getStdInEncodingOrNull() {
        return this.execPowerShell("[Console]::InputEncoding.WebName").map(String::trim).map(Charset::forName).orElse(null);
    }

    @Override
    public Charset getStdOutEncodingOrNull() {
        return this.execPowerShell("[Console]::OutputEncoding.WebName").map(String::trim).map(Charset::forName).orElse(null);
    }

    @Override
    public int getColumns() {
        return this.execPowerShell("(Get-Host).ui.rawui.windowsize.width").map(Integer::valueOf).orElse(-1);
    }

    @Override
    public int getRows() {
        return this.execPowerShell("(Get-Host).ui.rawui.windowsize.height").map(Integer::valueOf).orElse(-1);
    }

    private Optional<String> execPowerShell(String command) {
        String powershell = this.getExecutable();
        return powershell != null ? Utils.execToString(this.onError, powershell, "-command", command) : Optional.empty();
    }

    private String initExecutable() {
        if (OS.NAME.equals((Object)OS.Name.WINDOWS)) {
            return WIN_EXECUTABLE;
        }
        try {
            if (WhichWrapper.isAvailable(CORE_EXECUTABLE)) {
                return CORE_EXECUTABLE;
            }
        }
        catch (IOException ex) {
            this.onError.accept(ex, new String[]{"which"});
        }
        return null;
    }

    @Generated
    PowerShellConsoleProvider(@NonNull BiConsumer<IOException, String[]> onError) {
        if (onError == null) {
            throw new NullPointerException("onError is marked non-null but is null");
        }
        this.onError = onError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public String getExecutable() {
        Object value = this.executable.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.executable;
            synchronized (atomicReference) {
                value = this.executable.get();
                if (value == null) {
                    String actualValue = this.initExecutable();
                    value = actualValue == null ? this.executable : actualValue;
                    this.executable.set(value);
                }
            }
        }
        return (String)(value == this.executable ? null : value);
    }
}

