/*
 * Decompiled with CFR 0.152.
 */
package internal.console.properties.x;

import internal.console.properties.x.Utils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.function.BiConsumer;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.console.properties.ConsoleProperties;
import nbbrd.io.sys.OS;

public final class LocaleConsoleProvider
implements ConsoleProperties.Spi {
    @NonNull
    private final BiConsumer<IOException, String[]> onError;

    public LocaleConsoleProvider() {
        this(Utils::logCommandException);
    }

    @Override
    public boolean isAvailable() {
        switch (OS.NAME) {
            case MACOS: 
            case LINUX: 
            case SOLARIS: {
                return true;
            }
            case WINDOWS: {
                return Utils.isMingwXterm(System::getenv);
            }
        }
        return false;
    }

    @Override
    public int getRank() {
        return 20;
    }

    @Override
    public Charset getStdInEncodingOrNull() {
        return this.getLocaleEncodingOrNull();
    }

    @Override
    public Charset getStdOutEncodingOrNull() {
        return this.getLocaleEncodingOrNull();
    }

    @Override
    public int getColumns() {
        return -1;
    }

    @Override
    public int getRows() {
        return -1;
    }

    private Charset getLocaleEncodingOrNull() {
        return Utils.execToString(this.onError, "locale", "charmap").map(Charset::forName).orElse(null);
    }

    @Generated
    LocaleConsoleProvider(@NonNull BiConsumer<IOException, String[]> onError) {
        if (onError == null) {
            throw new NullPointerException("onError is marked non-null but is null");
        }
        this.onError = onError;
    }
}

