/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs.cli;

import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;
import picocli.CommandLine;

public final class PrintAndLogExceptionHandler
implements CommandLine.IExecutionExceptionHandler {
    @NonNull
    private final Class<?> logAnchor;
    private final boolean stackTraceRequired;

    public int handleExecutionException(Exception ex, CommandLine cmd, CommandLine.ParseResult parseResult) {
        this.reportToLogger(ex, parseResult);
        this.reportToConsole(ex, cmd);
        return cmd.getExitCodeExceptionMapper() != null ? cmd.getExitCodeExceptionMapper().getExitCode((Throwable)ex) : cmd.getCommandSpec().exitCodeOnExecutionException();
    }

    private void reportToLogger(Exception ex, CommandLine.ParseResult parseResult) {
        Logger logger = Logger.getLogger(this.logAnchor.getName());
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, "While executing command '" + String.join((CharSequence)" ", parseResult.originalArgs()) + "'", ex);
        }
    }

    private void reportToConsole(Exception ex, CommandLine cmd) {
        cmd.getErr().println(cmd.getColorScheme().errorText(this.getErrorMessage(ex)));
        if (this.stackTraceRequired) {
            cmd.getErr().println(cmd.getColorScheme().stackTraceText((Throwable)ex));
        }
    }

    private String getErrorMessage(Exception ex) {
        return this.getLabel(ex) + ": " + ex.getMessage();
    }

    private String getLabel(Exception ex) {
        if (ex instanceof IllegalArgumentException) {
            return "Invalid parameter";
        }
        return ex.getClass().getSimpleName();
    }

    @Generated
    public PrintAndLogExceptionHandler(@NonNull Class<?> logAnchor, boolean stackTraceRequired) {
        if (logAnchor == null) {
            throw new NullPointerException("logAnchor is marked non-null but is null");
        }
        this.logAnchor = logAnchor;
        this.stackTraceRequired = stackTraceRequired;
    }
}

