/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs.cli;

import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import lombok.Generated;
import nbbrd.console.picocli.text.TextOutput;
import nbbrd.console.properties.ConsoleProperties;
import picocli.CommandLine;

public class MarkdownOutputOptions
implements TextOutput {
    @CommandLine.Option(names={"-o", "--output"}, paramLabel="<file>", description={"Output to a file instead of stdout."})
    private Path file;

    public boolean isGzipped() {
        return false;
    }

    public boolean isAppend() {
        return false;
    }

    public Charset getEncoding() {
        return StandardCharsets.UTF_8;
    }

    public OutputStream getStdOutStream() {
        return System.out;
    }

    public Charset getStdOutEncoding() {
        return ConsoleProperties.ofServiceLoader().getStdOutEncoding().orElse(StandardCharsets.UTF_8);
    }

    public void write(Document document) throws IOException {
        Formatter formatter = Formatter.builder().build();
        try (Writer writer = this.newCharWriter();){
            formatter.render((Node)document, (Appendable)writer);
        }
    }

    @Generated
    public Path getFile() {
        return this.file;
    }

    @Generated
    public void setFile(Path file) {
        this.file = file;
    }
}

