/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import nbbrd.io.Resource;
import nbbrd.io.function.IOPredicate;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Zip {
    public static @NonNull Resource.Loader<String> loaderOf(@NonNull File file) throws IOException {
        ZipFile data = new ZipFile(file);
        return Resource.Loader.of(o -> Zip.getInputStream(data, o), data);
    }

    public static @NonNull Resource.Loader<String> loaderCopyOf(@NonNull InputStream inputStream, @NonNull IOPredicate<? super ZipEntry> filter) throws IOException {
        Map<String, byte[]> data = Zip.copyOf(inputStream, filter);
        return Resource.Loader.of(o -> Zip.getInputStream(data, o));
    }

    private static InputStream getInputStream(ZipFile zipFile, String name) throws IOException {
        ZipEntry result = zipFile.getEntry(name);
        if (result == null) {
            throw new IOException("Missing entry '" + name + "' in file '" + zipFile.getName() + "'");
        }
        return zipFile.getInputStream(result);
    }

    private static InputStream getInputStream(Map<String, byte[]> data, String name) throws IOException {
        byte[] result = data.get(name);
        if (result == null) {
            throw new IOException("Missing entry '" + name + "'");
        }
        return new ByteArrayInputStream(result);
    }

    private static Map<String, byte[]> copyOf(InputStream stream, IOPredicate<? super ZipEntry> filter) throws IOException {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        try (ZipInputStream zis = new ZipInputStream(stream);){
            Zip.forEach(zis, filter, (k, v) -> result.put(k.getName(), (byte[])v));
        }
        return result;
    }

    private static void forEach(ZipInputStream zis, IOPredicate<? super ZipEntry> filter, BiConsumer<ZipEntry, byte[]> consumer) throws IOException {
        ZipEntry entry;
        Objects.requireNonNull(filter);
        while ((entry = zis.getNextEntry()) != null) {
            if (!filter.testWithIO(entry)) continue;
            consumer.accept(entry, Zip.toByteArray(entry, zis));
        }
    }

    private static byte[] toByteArray(ZipEntry entry, ZipInputStream stream) throws IOException {
        int len;
        long size = entry.getSize();
        if (size >= Integer.MAX_VALUE) {
            throw new IOException("ZIP entry size is too large");
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream(size > 0L ? (int)size : 4096);
        byte[] buffer = new byte[4096];
        while ((len = stream.read(buffer)) != -1) {
            result.write(buffer, 0, len);
        }
        return result.toByteArray();
    }

    @Generated
    private Zip() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

