/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.text;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import nbbrd.io.text.BaseProperty;
import nbbrd.io.text.Formatter;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Property<T>
extends BaseProperty {
    @lombok.NonNull
    private final String key;
    private final @Nullable T defaultValue;
    @lombok.NonNull
    private final Parser<T> parser;
    @lombok.NonNull
    private final Formatter<T> formatter;

    public @Nullable T get(@NonNull Function<? super String, ? extends CharSequence> properties) {
        CharSequence value = properties.apply(this.key);
        if (value == null) {
            return this.defaultValue;
        }
        T result = this.parser.parse(value);
        return result != null ? result : this.defaultValue;
    }

    public @Nullable T get(@NonNull Properties properties) {
        return this.get(properties::getProperty);
    }

    public @Nullable T get(@NonNull Map<String, String> properties) {
        return this.get(properties::get);
    }

    public void set(@NonNull BiConsumer<? super String, ? super String> properties, @Nullable T value) {
        String valueAsString;
        Objects.requireNonNull(properties);
        if (!Objects.equals(value, this.defaultValue) && (valueAsString = this.formatter.formatAsString(value)) != null) {
            properties.accept(this.key, valueAsString);
        }
    }

    public void set(@NonNull Properties properties, T value) {
        this.set(properties::setProperty, value);
    }

    public void set(@NonNull Map<String, String> properties, T value) {
        this.set(properties::put, value);
    }

    @Generated
    private Property(@lombok.NonNull String key, @Nullable T defaultValue, @lombok.NonNull Parser<T> parser, @lombok.NonNull Formatter<T> formatter) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        this.key = key;
        this.defaultValue = defaultValue;
        this.parser = parser;
        this.formatter = formatter;
    }

    @Generated
    public static <T> @NonNull Property<T> of(@lombok.NonNull String key, @Nullable T defaultValue, @lombok.NonNull Parser<T> parser, @lombok.NonNull Formatter<T> formatter) {
        return new Property<T>(key, defaultValue, parser, formatter);
    }

    @Override
    @lombok.NonNull
    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public @Nullable T getDefaultValue() {
        return this.defaultValue;
    }
}

