/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.sys;

import java.util.Locale;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class OS {
    public static final Name NAME = Name.parse(System.getProperty("os.name"));

    @Generated
    private OS() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum Name {
        WINDOWS,
        LINUX,
        SOLARIS,
        MACOS,
        UNKNOWN;


        public static @NonNull Name parse(@Nullable String osName) {
            if (osName != null) {
                String str = osName.toLowerCase(Locale.ROOT);
                if (str.contains("win")) {
                    return WINDOWS;
                }
                if (str.contains("linux")) {
                    return LINUX;
                }
                if (str.contains("solaris") || str.contains("sunos")) {
                    return SOLARIS;
                }
                if (str.contains("mac")) {
                    return MACOS;
                }
            }
            return UNKNOWN;
        }
    }
}

