/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
public interface IOPredicate<T> {
    public boolean testWithIO(T var1) throws IOException;

    default public @NonNull IOPredicate<T> and(@NonNull IOPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.testWithIO(t) && other.testWithIO(t);
    }

    default public @NonNull IOPredicate<T> negate() {
        return t -> !this.testWithIO(t);
    }

    default public @NonNull IOPredicate<T> or(@NonNull IOPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.testWithIO(t) || other.testWithIO(t);
    }

    default public @NonNull Predicate<T> asUnchecked() {
        return t -> {
            try {
                return this.testWithIO(t);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static <T> @NonNull Predicate<T> unchecked(@NonNull IOPredicate<T> o) {
        return o.asUnchecked();
    }

    public static <T> @NonNull IOPredicate<T> checked(@NonNull Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        return o -> {
            try {
                return predicate.test(o);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        };
    }

    public static <T> @NonNull IOPredicate<T> isEqual(Object targetRef) {
        return null == targetRef ? Objects::isNull : targetRef::equals;
    }

    public static <T> @NonNull IOPredicate<T> of(boolean r) {
        return o -> r;
    }
}

