/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
public interface IOFunction<T, R> {
    public R applyWithIO(T var1) throws IOException;

    default public <V> @NonNull IOFunction<V, R> compose(@NonNull IOFunction<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        return v -> this.applyWithIO(before.applyWithIO((Object)v));
    }

    default public <V> @NonNull IOFunction<T, V> andThen(@NonNull IOFunction<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return t -> after.applyWithIO((R)this.applyWithIO(t));
    }

    default public @NonNull Function<T, R> asUnchecked() {
        return t -> {
            try {
                return this.applyWithIO(t);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static <T, R> @NonNull Function<T, R> unchecked(@NonNull IOFunction<T, R> o) {
        return o.asUnchecked();
    }

    public static <T, R> @NonNull IOFunction<T, R> checked(@NonNull Function<T, R> func) {
        Objects.requireNonNull(func);
        return o -> {
            try {
                return func.apply(o);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        };
    }

    public static <T> @NonNull IOFunction<T, T> identity() {
        return t -> t;
    }

    public static <T, R> @NonNull IOFunction<T, R> of(@Nullable R r) {
        return o -> r;
    }
}

