/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io;

import internal.io.IOIterators;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import nbbrd.io.function.IOConsumer;
import nbbrd.io.function.IOPredicate;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.function.IOUnaryOperator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface IOIterator<E> {
    public boolean hasNextWithIO() throws IOException;

    public @Nullable E nextWithIO() throws IOException, NoSuchElementException;

    default public void removeWithIO() throws IOException {
        throw new UnsupportedOperationException("remove");
    }

    default public void forEachRemainingWithIO(@NonNull IOConsumer<? super E> action) throws IOException {
        Objects.requireNonNull(action);
        while (this.hasNextWithIO()) {
            action.acceptWithIO(this.nextWithIO());
        }
    }

    default public @NonNull Stream<E> asStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.asUnchecked(), 0), false);
    }

    default public @NonNull Iterator<E> asUnchecked() {
        return new IOIterators.Unchecked(this);
    }

    public static <E> @NonNull IOIterator<E> empty() {
        return IOIterators.Empty.INSTANCE;
    }

    public static <E> @NonNull IOIterator<E> singleton(@NonNull E element) {
        return new IOIterators.Singleton<E>(element);
    }

    public static <E> @NonNull IOIterator<E> checked(@NonNull Iterator<E> iterator) {
        return iterator instanceof IOIterators.Unchecked ? ((IOIterators.Unchecked)iterator).getDelegate() : new IOIterators.Checked<E>(iterator);
    }

    public static <E> @NonNull Iterator<E> unchecked(@NonNull IOIterator<E> iterator) {
        return iterator instanceof IOIterators.Checked ? ((IOIterators.Checked)iterator).getDelegate() : new IOIterators.Unchecked<E>(iterator);
    }

    public static <E> @NonNull IOIterator<E> iterate(@NonNull IOSupplier<E> seed, @NonNull IOPredicate<? super E> hasNext, @NonNull IOUnaryOperator<E> next) {
        return new IOIterators.Functional<E>(seed, hasNext, next);
    }

    public static <E> @NonNull IOIterator<E> generateWhile(@NonNull IOSupplier<E> supplier, @NonNull IOPredicate<? super E> predicate) {
        return IOIterator.iterate(supplier, predicate, value -> supplier.getWithIO());
    }
}

