/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io;

import internal.io.AndThenFileParser;
import internal.io.text.LegacyFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import nbbrd.io.Resource;
import nbbrd.io.function.IOSupplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface FileParser<T> {
    default public @NonNull T parseFile(@NonNull File source) throws IOException {
        LegacyFiles.checkSource(source);
        return this.parseStream(() -> LegacyFiles.newInputStream(source));
    }

    default public @NonNull T parsePath(@NonNull Path source) throws IOException {
        Objects.requireNonNull(source, "source");
        Optional<File> file = Resource.getFile(source);
        return file.isPresent() ? this.parseFile(file.get()) : this.parseStream(() -> Files.newInputStream(source, new OpenOption[0]));
    }

    default public @NonNull T parseResource(@NonNull Class<?> type, @NonNull String name) throws IOException {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(name, "name");
        return this.parseStream(() -> LegacyFiles.checkResource(type.getResourceAsStream(name), "Missing resource '" + name + "' of '" + type.getName() + "'"));
    }

    default public @NonNull T parseStream(IOSupplier<? extends InputStream> source) throws IOException {
        Objects.requireNonNull(source, "source");
        try (InputStream resource = LegacyFiles.checkResource(source.getWithIO(), "Missing InputStream");){
            T t = this.parseStream(resource);
            return t;
        }
    }

    public @NonNull T parseStream(@NonNull InputStream var1) throws IOException;

    default public <V> @NonNull FileParser<V> andThen(@NonNull Function<? super T, ? extends V> after) {
        return new AndThenFileParser<T, V>(this, after);
    }
}

