/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class BlockSizer {
    public static final AtomicReference<BlockSizer> INSTANCE = new AtomicReference<BlockSizer>(new BlockSizer());
    public static final long DEFAULT_BLOCK_BUFFER_SIZE = 512L;
    public static final long DEFAULT_BUFFER_OUTPUT_STREAM_SIZE = 8192L;
    public static final long UNKNOWN_SIZE = -1L;

    public long getBlockSize(Path file) throws IOException {
        Objects.requireNonNull(file);
        return 512L;
    }

    public long getBlockSize(InputStream stream) throws IOException {
        return stream.available();
    }

    public long getBlockSize(OutputStream stream) throws IOException {
        Objects.requireNonNull(stream);
        return stream instanceof BufferedOutputStream ? 8192L : -1L;
    }
}

