/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.RefNode;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.regex.Pattern;
import lombok.Generated;
import nbbrd.heylogs.Nodes;
import nbbrd.heylogs.Version;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class VersionFilter {
    public static final VersionFilter DEFAULT = VersionFilter.builder().build();
    @lombok.NonNull
    private final String ref;
    @lombok.NonNull
    private final Pattern unreleasedPattern;
    @lombok.NonNull
    private final LocalDate from;
    @lombok.NonNull
    private final LocalDate to;
    private final int limit;

    private boolean isUnreleasedPattern() {
        return this.unreleasedPattern.asPredicate().test(this.ref);
    }

    private boolean containsRef(Version version) {
        return this.isUnreleasedPattern() && version.isUnreleased() || version.getRef().contains(this.ref);
    }

    public boolean contains(Heading heading) {
        return this.contains(Version.parse(heading));
    }

    public boolean contains(Version version) {
        return this.containsRef(version) && this.from.compareTo(version.getDate()) <= 0 && (this.to.isAfter(version.getDate()) || this.to.equals(LocalDate.MAX) && version.isUnreleased());
    }

    public void apply(Document root) {
        int found = 0;
        boolean keep = false;
        ArrayList refNodes = new ArrayList();
        ArrayList<Reference> references = new ArrayList<Reference>();
        for (Node current : root.getChildren()) {
            if (current instanceof Heading && Version.isVersionLevel((Heading)current)) {
                if (found >= this.getLimit() || !this.contains((Heading)current)) {
                    keep = false;
                } else {
                    ++found;
                    keep = true;
                }
            }
            if (keep) {
                Nodes.of(RefNode.class).descendants(current).map(node -> node.getReference().toString()).forEach(refNodes::add);
                continue;
            }
            if (current instanceof Reference) {
                references.add((Reference)current);
                continue;
            }
            current.unlink();
        }
        references.stream().filter(reference -> !refNodes.contains(reference.getReference().toString())).forEach(Node::unlink);
    }

    public static LocalDate parseLocalDate(CharSequence input) {
        try {
            return Year.parse(input).atDay(1);
        }
        catch (Exception ex1) {
            try {
                return YearMonth.parse(input).atDay(1);
            }
            catch (Exception ex2) {
                return LocalDate.parse(input);
            }
        }
    }

    @Generated
    private static String $default$ref() {
        return "";
    }

    @Generated
    private static Pattern $default$unreleasedPattern() {
        return Pattern.compile("^.*-SNAPSHOT$");
    }

    @Generated
    private static LocalDate $default$from() {
        return LocalDate.MIN;
    }

    @Generated
    private static LocalDate $default$to() {
        return LocalDate.MAX;
    }

    @Generated
    private static int $default$limit() {
        return Integer.MAX_VALUE;
    }

    @Generated
    VersionFilter(@lombok.NonNull String ref, @lombok.NonNull Pattern unreleasedPattern, @lombok.NonNull LocalDate from, @lombok.NonNull LocalDate to, int limit) {
        if (ref == null) {
            throw new NullPointerException("ref is marked non-null but is null");
        }
        if (unreleasedPattern == null) {
            throw new NullPointerException("unreleasedPattern is marked non-null but is null");
        }
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        this.ref = ref;
        this.unreleasedPattern = unreleasedPattern;
        this.from = from;
        this.to = to;
        this.limit = limit;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @lombok.NonNull
    @Generated
    public String getRef() {
        return this.ref;
    }

    @lombok.NonNull
    @Generated
    public Pattern getUnreleasedPattern() {
        return this.unreleasedPattern;
    }

    @lombok.NonNull
    @Generated
    public LocalDate getFrom() {
        return this.from;
    }

    @lombok.NonNull
    @Generated
    public LocalDate getTo() {
        return this.to;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionFilter)) {
            return false;
        }
        VersionFilter other = (VersionFilter)o;
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
            return false;
        }
        Pattern this$unreleasedPattern = this.getUnreleasedPattern();
        Pattern other$unreleasedPattern = other.getUnreleasedPattern();
        if (this$unreleasedPattern == null ? other$unreleasedPattern != null : !this$unreleasedPattern.equals(other$unreleasedPattern)) {
            return false;
        }
        LocalDate this$from = this.getFrom();
        LocalDate other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        LocalDate this$to = this.getTo();
        LocalDate other$to = other.getTo();
        return !(this$to == null ? other$to != null : !((Object)this$to).equals(other$to));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLimit();
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        Pattern $unreleasedPattern = this.getUnreleasedPattern();
        result = result * 59 + ($unreleasedPattern == null ? 43 : $unreleasedPattern.hashCode());
        LocalDate $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        LocalDate $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "VersionFilter(ref=" + this.getRef() + ", unreleasedPattern=" + this.getUnreleasedPattern() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", limit=" + this.getLimit() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean ref$set;
        @Generated
        private String ref$value;
        @Generated
        private boolean unreleasedPattern$set;
        @Generated
        private Pattern unreleasedPattern$value;
        @Generated
        private boolean from$set;
        @Generated
        private LocalDate from$value;
        @Generated
        private boolean to$set;
        @Generated
        private LocalDate to$value;
        @Generated
        private boolean limit$set;
        @Generated
        private int limit$value;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder ref(@lombok.NonNull String ref) {
            if (ref == null) {
                throw new NullPointerException("ref is marked non-null but is null");
            }
            this.ref$value = ref;
            this.ref$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder unreleasedPattern(@lombok.NonNull Pattern unreleasedPattern) {
            if (unreleasedPattern == null) {
                throw new NullPointerException("unreleasedPattern is marked non-null but is null");
            }
            this.unreleasedPattern$value = unreleasedPattern;
            this.unreleasedPattern$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder from(@lombok.NonNull LocalDate from) {
            if (from == null) {
                throw new NullPointerException("from is marked non-null but is null");
            }
            this.from$value = from;
            this.from$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder to(@lombok.NonNull LocalDate to) {
            if (to == null) {
                throw new NullPointerException("to is marked non-null but is null");
            }
            this.to$value = to;
            this.to$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder limit(int limit) {
            this.limit$value = limit;
            this.limit$set = true;
            return this;
        }

        @Generated
        public @NonNull VersionFilter build() {
            String ref$value = this.ref$value;
            if (!this.ref$set) {
                ref$value = VersionFilter.$default$ref();
            }
            Pattern unreleasedPattern$value = this.unreleasedPattern$value;
            if (!this.unreleasedPattern$set) {
                unreleasedPattern$value = VersionFilter.$default$unreleasedPattern();
            }
            LocalDate from$value = this.from$value;
            if (!this.from$set) {
                from$value = VersionFilter.$default$from();
            }
            LocalDate to$value = this.to$value;
            if (!this.to$set) {
                to$value = VersionFilter.$default$to();
            }
            int limit$value = this.limit$value;
            if (!this.limit$set) {
                limit$value = VersionFilter.$default$limit();
            }
            return new VersionFilter(ref$value, unreleasedPattern$value, from$value, to$value, limit$value);
        }

        @Generated
        public @NonNull String toString() {
            return "VersionFilter.Builder(ref$value=" + this.ref$value + ", unreleasedPattern$value=" + this.unreleasedPattern$value + ", from$value=" + this.from$value + ", to$value=" + this.to$value + ", limit$value=" + this.limit$value + ")";
        }
    }
}

