/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterator;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import lombok.Generated;
import nbbrd.heylogs.BaseSection;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Version
implements BaseSection {
    private static final String UNRELEASED_KEYWORD = "unreleased";
    private static final int HEADING_LEVEL = 2;
    @lombok.NonNull
    private final String ref;
    @lombok.NonNull
    private final LocalDate date;

    public boolean isUnreleased() {
        return UNRELEASED_KEYWORD.equalsIgnoreCase(this.ref);
    }

    @Override
    public Heading toHeading() {
        Heading result = new Heading();
        result.setOpeningMarker(BasedSequence.repeatOf("#", 2));
        result.setLevel(2);
        LinkRef firstPart = new LinkRef();
        firstPart.setReferenceOpeningMarker(BasedSequence.of("["));
        firstPart.setReferenceClosingMarker(BasedSequence.of("]"));
        firstPart.setReference(BasedSequence.of(this.ref));
        result.appendChild(firstPart);
        if (!this.isUnreleased()) {
            Text secondPart = new Text();
            secondPart.setChars((BasedSequence)BasedSequence.of(" - ").append(this.date.toString()));
            result.appendChild(secondPart);
        }
        return result;
    }

    public static Version parse(Heading heading) {
        if (!Version.isVersionLevel(heading)) {
            throw new IllegalArgumentException("Invalid heading level");
        }
        ReversiblePeekingIterator<Node> parts = heading.getChildIterator();
        if (!parts.hasNext()) {
            throw new IllegalArgumentException("Missing ref part");
        }
        String ref = Version.parseRef((Node)parts.next());
        if (ref.equalsIgnoreCase(UNRELEASED_KEYWORD)) {
            if (parts.hasNext()) {
                throw new IllegalArgumentException("Unexpected additional part: '" + ((Node)parts.next()).getChars() + "'");
            }
            return new Version(ref, LocalDate.MAX);
        }
        if (!parts.hasNext()) {
            throw new IllegalArgumentException("Missing date part");
        }
        LocalDate date = Version.parseDate((Node)parts.next());
        if (parts.hasNext()) {
            throw new IllegalArgumentException("Unexpected additional part: '" + ((Node)parts.next()).getChars() + "'");
        }
        return new Version(ref, date);
    }

    private static String parseRef(Node firstPart) throws IllegalArgumentException {
        if (!(firstPart instanceof LinkRef)) {
            throw new IllegalArgumentException("Missing ref link");
        }
        return ((LinkRef)firstPart).getReference().toString();
    }

    private static LocalDate parseDate(Node secondPart) throws IllegalArgumentException {
        if (!(secondPart instanceof Text)) {
            throw new IllegalArgumentException("Invalid date type");
        }
        BasedSequence date = secondPart.getChars();
        if (!((BasedSequence)date.trimStart()).startsWith("-")) {
            throw new IllegalArgumentException("Missing date prefix");
        }
        BasedSequence x = (BasedSequence)((BasedSequence)date.safeSubSequence(3)).trim();
        try {
            return LocalDate.parse(x);
        }
        catch (DateTimeParseException ex) {
            throw new IllegalArgumentException("Invalid date format");
        }
    }

    public static boolean isVersionLevel(Heading heading) {
        return heading.getLevel() == 2;
    }

    @Generated
    public Version(@lombok.NonNull String ref, @lombok.NonNull LocalDate date) {
        if (ref == null) {
            throw new NullPointerException("ref is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        this.ref = ref;
        this.date = date;
    }

    @lombok.NonNull
    @Generated
    public String getRef() {
        return this.ref;
    }

    @lombok.NonNull
    @Generated
    public LocalDate getDate() {
        return this.date;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
            return false;
        }
        LocalDate this$date = this.getDate();
        LocalDate other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        LocalDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "Version(ref=" + this.getRef() + ", date=" + this.getDate() + ")";
    }
}

