/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import java.io.IOException;
import java.util.List;
import nbbrd.heylogs.Failure;
import nbbrd.heylogs.FailureFormatter;

public final class StylishFormatter
implements FailureFormatter {
    @Override
    public String getName() {
        return "stylish";
    }

    @Override
    public void format(Appendable appendable, String source, List<Failure> failures) throws IOException {
        appendable.append(source).append(System.lineSeparator());
        int l = failures.stream().mapToInt(failure -> StylishFormatter.getNumberOfDigits(failure.getLine())).max().orElse(0);
        int c = failures.stream().mapToInt(failure -> StylishFormatter.getNumberOfDigits(failure.getColumn())).max().orElse(0);
        int m = failures.stream().mapToInt(failure -> failure.getMessage().length()).max().orElse(0);
        for (Failure failure2 : failures) {
            appendable.append(String.format("  %" + l + "d:%-" + c + "d  error  %-" + m + "s  %s", failure2.getLine(), failure2.getColumn(), failure2.getMessage(), failure2.getRule())).append(System.lineSeparator());
        }
        appendable.append(System.lineSeparator());
        switch (failures.size()) {
            case 0: {
                appendable.append("  No problem");
                break;
            }
            case 1: {
                appendable.append("  1 problem");
                break;
            }
            default: {
                appendable.append(String.format("  %d problems", failures.size()));
            }
        }
        appendable.append(System.lineSeparator());
    }

    private static int getNumberOfDigits(int number) {
        return (int)(Math.log10(number) + 1.0);
    }
}

