/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import nbbrd.design.VisibleForTesting;
import nbbrd.heylogs.Changelog;
import nbbrd.heylogs.Failure;
import nbbrd.heylogs.Nodes;
import nbbrd.heylogs.Rule;
import nbbrd.heylogs.RuleBatch;
import nbbrd.heylogs.TypeOfChange;
import nbbrd.heylogs.Version;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public enum GuidingPrinciples implements Rule
{
    FOR_HUMANS{

        @Override
        public Failure validate(Node node) {
            return node instanceof Document ? 1.validateForHumans((Document)node) : null;
        }
    }
    ,
    ENTRY_FOR_EVERY_VERSIONS{

        @Override
        public Failure validate(Node node) {
            return node instanceof Heading ? 2.validateEntryForEveryVersions((Heading)node) : null;
        }
    }
    ,
    TYPE_OF_CHANGES_GROUPED{

        @Override
        public Failure validate(Node node) {
            return node instanceof Heading ? 3.validateTypeOfChangesGrouped((Heading)node) : null;
        }
    }
    ,
    LINKABLE{

        @Override
        public Failure validate(Node node) {
            return node instanceof Heading ? 4.validateLinkable((Heading)node) : null;
        }
    }
    ,
    LATEST_VERSION_FIRST{

        @Override
        public Failure validate(Node node) {
            return node instanceof Document ? 5.validateLatestVersionFirst((Document)node) : null;
        }
    }
    ,
    DATE_DISPLAYED{

        @Override
        public Failure validate(Node node) {
            return null;
        }
    }
    ,
    SEMVER{

        @Override
        public Failure validate(Node node) {
            return null;
        }
    };


    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ROOT).replace('_', '-');
    }

    @VisibleForTesting
    static Failure validateForHumans(@NotNull Document document) {
        List headings = Nodes.of(Heading.class).descendants(document).filter(Changelog::isChangelogLevel).collect(Collectors.toList());
        switch (headings.size()) {
            case 0: {
                return Failure.of(FOR_HUMANS, "Missing Changelog heading", document);
            }
            case 1: {
                try {
                    Changelog.parse((Heading)headings.get(0));
                    return null;
                }
                catch (IllegalArgumentException ex) {
                    return Failure.of(FOR_HUMANS, ex.getMessage(), document);
                }
            }
        }
        return Failure.of(FOR_HUMANS, "Too many Changelog headings", document);
    }

    @VisibleForTesting
    static Failure validateEntryForEveryVersions(@NotNull Heading heading) {
        if (!Version.isVersionLevel(heading)) {
            return null;
        }
        try {
            Version.parse(heading);
        }
        catch (IllegalArgumentException ex) {
            return Failure.of(ENTRY_FOR_EVERY_VERSIONS, ex.getMessage(), heading);
        }
        return null;
    }

    @VisibleForTesting
    static Failure validateTypeOfChangesGrouped(@NotNull Heading heading) {
        if (!TypeOfChange.isTypeOfChangeLevel(heading)) {
            return null;
        }
        try {
            TypeOfChange.parse(heading);
        }
        catch (IllegalArgumentException ex) {
            return Failure.of(TYPE_OF_CHANGES_GROUPED, ex.getMessage(), heading);
        }
        return null;
    }

    @VisibleForTesting
    static Failure validateLinkable(@NotNull Heading heading) {
        if (!Version.isVersionLevel(heading)) {
            return null;
        }
        try {
            Version version = Version.parse(heading);
            ReferenceRepository repository = Parser.REFERENCES.get(heading.getDocument());
            String normalizeRef = repository.normalizeKey(version.getRef());
            Reference reference = (Reference)repository.get(normalizeRef);
            return reference == null ? Failure.of(LINKABLE, "Missing reference '" + version.getRef() + "'", heading) : null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @VisibleForTesting
    static Failure validateLatestVersionFirst(@NotNull Document doc) {
        Comparator<VersionNode> comparator;
        List<VersionNode> versions = VersionNode.allOf(doc);
        VersionNode unsortedItem = GuidingPrinciples.getFirstUnsortedItem(versions, comparator = Comparator.comparing(item -> item.getVersion().getDate()).reversed());
        return unsortedItem != null ? Failure.of(LATEST_VERSION_FIRST, "Versions not sorted", unsortedItem.getNode()) : null;
    }

    private static <T> T getFirstUnsortedItem(List<T> list, Comparator<T> comparator) {
        if (list.isEmpty() || list.size() == 1) {
            return null;
        }
        Iterator<T> iterator = list.iterator();
        T previous = iterator.next();
        while (iterator.hasNext()) {
            T current = iterator.next();
            if (comparator.compare(previous, current) > 0) {
                return current;
            }
            previous = current;
        }
        return null;
    }

    private static final class VersionNode {
        private final Version version;
        private final Node node;

        static List<VersionNode> allOf(Document doc) {
            return Nodes.of(Heading.class).descendants(doc).filter(Version::isVersionLevel).map(node -> {
                try {
                    return new VersionNode(Version.parse(node), (Node)node);
                }
                catch (IllegalArgumentException ex) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }

        @Generated
        public VersionNode(Version version, Node node) {
            this.version = version;
            this.node = node;
        }

        @Generated
        public Version getVersion() {
            return this.version;
        }

        @Generated
        public Node getNode() {
            return this.node;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VersionNode)) {
                return false;
            }
            VersionNode other = (VersionNode)o;
            Version this$version = this.getVersion();
            Version other$version = other.getVersion();
            if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
                return false;
            }
            Node this$node = this.getNode();
            Node other$node = other.getNode();
            return !(this$node == null ? other$node != null : !this$node.equals(other$node));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Version $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            Node $node = this.getNode();
            result = result * 59 + ($node == null ? 43 : $node.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "GuidingPrinciples.VersionNode(version=" + this.getVersion() + ", node=" + this.getNode() + ")";
        }
    }

    public static final class Batch
    implements RuleBatch {
        @Override
        public Stream<Rule> getProviders() {
            return Stream.of(GuidingPrinciples.values());
        }
    }
}

