/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import nbbrd.heylogs.Nodes;
import nbbrd.heylogs.Rule;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Failure {
    @lombok.NonNull
    private final String rule;
    @lombok.NonNull
    private final String message;
    private final int line;
    private final int column;

    public static Failure of(Rule rule, String message, Node node) {
        return new Failure(rule.getName(), message, node.getStartLineNumber() + 1, node.lineColumnAtStart().getSecond() + 1);
    }

    public static Failure of(Rule rule, String message, int line, int column) {
        return new Failure(rule.getName(), message, line, column);
    }

    public static List<Failure> allOf(Document doc, List<Rule> rules) {
        return Stream.concat(Stream.of(doc), Nodes.of(Node.class).descendants(doc)).flatMap(node -> rules.stream().map(rule -> rule.validate((Node)node)).filter(Objects::nonNull)).collect(Collectors.toList());
    }

    @lombok.NonNull
    @Generated
    public String getRule() {
        return this.rule;
    }

    @lombok.NonNull
    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public int getLine() {
        return this.line;
    }

    @Generated
    public int getColumn() {
        return this.column;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Failure)) {
            return false;
        }
        Failure other = (Failure)o;
        if (this.getLine() != other.getLine()) {
            return false;
        }
        if (this.getColumn() != other.getColumn()) {
            return false;
        }
        String this$rule = this.getRule();
        String other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLine();
        result = result * 59 + this.getColumn();
        String $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "Failure(rule=" + this.getRule() + ", message=" + this.getMessage() + ", line=" + this.getLine() + ", column=" + this.getColumn() + ")";
    }

    @Generated
    private Failure(@lombok.NonNull String rule, @lombok.NonNull String message, int line, int column) {
        if (rule == null) {
            throw new NullPointerException("rule is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.rule = rule;
        this.message = message;
        this.line = line;
        this.column = column;
    }
}

