/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.LinkNodeBase;
import com.vladsch.flexmark.util.ast.Node;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.stream.Stream;
import nbbrd.design.VisibleForTesting;
import nbbrd.heylogs.Failure;
import nbbrd.heylogs.Rule;
import nbbrd.heylogs.RuleBatch;
import org.jetbrains.annotations.NotNull;

public enum ExtendedRules implements Rule
{
    LIMIT_HEADING_DEPTH{

        @Override
        public Failure validate(Node node) {
            return node instanceof Heading ? 1.validateLimitHeadingDepth((Heading)node) : null;
        }
    }
    ,
    HTTPS{

        @Override
        public Failure validate(Node node) {
            return node instanceof LinkNodeBase ? 2.validateHttps((LinkNodeBase)node) : null;
        }
    }
    ,
    GITHUB_ISSUE_REF{

        @Override
        public Failure validate(Node node) {
            return node instanceof Link ? 3.validateGitHubIssueRef((Link)node) : null;
        }
    };


    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ROOT).replace('_', '-');
    }

    @VisibleForTesting
    static Failure validateLimitHeadingDepth(@NotNull Heading heading) {
        return heading.getLevel() > 3 ? Failure.of(LIMIT_HEADING_DEPTH, "Not expecting level " + heading.getLevel() + "", heading) : null;
    }

    @VisibleForTesting
    static Failure validateHttps(LinkNodeBase link) {
        try {
            if (new URL(link.getUrl().toString()).getProtocol().equals("http")) {
                return Failure.of(HTTPS, "Expecting HTTPS protocol", link);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    @VisibleForTesting
    static Failure validateGitHubIssueRef(Link link) {
        int expected = ExtendedRules.getGitHubIssueRefFromURL(link);
        int found = ExtendedRules.getGitHubIssueRefFromText(link);
        return expected != -1 && found != -1 && expected != found ? Failure.of(GITHUB_ISSUE_REF, "Expecting GitHub issue ref " + expected + ", found " + found, link) : null;
    }

    private static int getGitHubIssueRefFromURL(Link link) {
        try {
            int index;
            URL url = new URL(link.getUrl().toString());
            if (url.getHost().equals("github.com") && (index = url.getPath().indexOf("/issues/")) != -1) {
                return Integer.parseInt(url.getPath().substring(index + 8));
            }
        }
        catch (NumberFormatException | MalformedURLException exception) {
            // empty catch block
        }
        return -1;
    }

    private static int getGitHubIssueRefFromText(Link link) {
        try {
            String text = link.getText().toString();
            if (text.startsWith("#")) {
                return Integer.parseInt(text.substring(1));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public static final class Batch
    implements RuleBatch {
        @Override
        public Stream<Rule> getProviders() {
            return Stream.of(ExtendedRules.values());
        }
    }
}

